package ru.yandex.serpbugcatcher.datalayer;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

import ru.yandex.serpbugcatcher.view.MainActivity;
import ru.yandex.serpbugcatcher.model.Query;
import ru.yandex.serpbugcatcher.R;

/**
 * Created by ajkon on 16-10-17.
 */

public class MetricsLayer {

    public Query[] getQueries() throws Exception {

        ByteArrayOutputStream out = new ByteArrayOutputStream();

//        URL url = new URL("http://metrics.yandex-team.ru/services/api/queriesgroup/list?id=11077");
//        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
//        try (InputStream is = connection.getInputStream()) {
        try (InputStream is = MainActivity.getAppContext().getResources().openRawResource(R.raw.basket)) {
            byte buf[] = new byte[4096];
            for (int n = is.read(buf); n > 0; n = is.read(buf)) {
                out.write(buf, 0, n);
            }
        }
        byte[] data = out.toByteArray();
        String jsonString = new String(data, StandardCharsets.UTF_8);
        JSONArray jsonArray = new JSONArray(jsonString);
        Query[] queries = new Query[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); i++) {
            JSONObject jsonQuery = jsonArray.getJSONObject(i);
            String text = jsonQuery.getString("text");
            JSONObject jsonRegion = jsonQuery.getJSONObject("region");
            int regionId = jsonRegion.getInt("id");
            queries[i] = new Query(text, regionId);
        }
        return queries;
    }


}
