package ru.yandex.serpbugcatcher.kernel;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.RequiresApi;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

import ru.yandex.serpbugcatcher.model.LogEvent;
import ru.yandex.serpbugcatcher.model.Query;

/**
 * Created by ajkon on 16-10-11.
 */

public class Logger {

    public Logger() {
    }

    private String url = null;

    private Date date;

    public void setUrl(String url) {
        this.url = url;
        setDate(new Date());
    }

    public String getUrl() {
        return url;
    }

    private String startCookies = "";

    public String getStartCookies() {
        return startCookies;
    }

    public void setStartCookies(String startCookies) {
        this.startCookies = startCookies;
    }

    private String endCookies = "";

    public String getEndCookies() {
        return endCookies;
    }

    public void setEndCookies(String endCookies) {
        this.endCookies = endCookies;
        setMda0(endCookies.contains("mda=0"));
    }


    private boolean isClearCache = false;

    public boolean isClearCache() {
        return isClearCache;
    }

    public void setClearCache(boolean clearCache) {
        isClearCache = clearCache;
    }


    private String reqid = "";

    public String getReqid() {
        return reqid;
    }

    public void setReqid(String reqid) {
        this.reqid = reqid;
    }

    public boolean hasReqid() {
        return (reqid != null && reqid.length() > 0);
    }


    private Query iterationQuery;

    public Query getIterationQuery() {
        return iterationQuery;
    }

    public void setIterationQuery(Query iterationQuery) {
        this.iterationQuery = iterationQuery;
    }


    public final LinkedBlockingQueue<LogEvent> lifeCycleLog = new LinkedBlockingQueue<LogEvent>();


    private boolean isMda0 = false;


    public void addInfo(String text) {
        addLogEvent(text, false, false);
    }

    public void addNetworkError(String text) {
        addLogEvent(text, true, false);
    }

    public void addScriptError(String text) {
        addLogEvent(text, false, true);
    }

    public LogEvent addLogEvent(String text, boolean isNetworkError, boolean isScriptError) {
        LogEvent logEvent = new LogEvent();
        logEvent.text = text;
        logEvent.isNetworkError = isNetworkError;
        logEvent.isScriptError = isScriptError;
        lifeCycleLog.add(logEvent);
        if (isNetworkError) hasNetworkError = true;
        if (isScriptError) hasScriptError = true;
        return logEvent;
    }


    public void clear() {
        lifeCycleLog.clear();
        setUrl(null);
        setClearCache(false);
        setStartCookies("");
        setEndCookies("");
        setReqid("");
        setIterationQuery(new Query("", 0));
        hasNetworkError = false;
        hasScriptError = false;
    }


    public boolean isMda0() {
        return isMda0;
    }

    public void setMda0(boolean mda0) {
        isMda0 = mda0;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }


    private boolean hasNetworkError;

    public boolean hasNetworkError() {
        return hasNetworkError;
    }

    private boolean hasScriptError;

    public boolean hasScriptError() {
        return hasNetworkError;
    }


    public boolean hasErrors() {
        return hasNetworkError || hasScriptError;
    }


//
//
//    @TargetApi(Build.VERSION_CODES.M)
//    @RequiresApi(api = Build.VERSION_CODES.M)
//    public  boolean hasNetworkError() {
//        for (Iterator<LogEvent> logEventIterator = lifeCycleLog.iterator(); logEventIterator.hasNext(); ) {
//            LogEvent logEvent = logEventIterator.next();
//            if (logEvent.isNetworkError) return true;
//        }
//        return false;
//    }
//
//    @TargetApi(Build.VERSION_CODES.M)
//    @RequiresApi(api = Build.VERSION_CODES.M)
//    public  boolean hasScriptError() {
//        for (Iterator<LogEvent> logEventIterator = lifeCycleLog.iterator(); logEventIterator.hasNext(); ) {
//            LogEvent logEvent = logEventIterator.next();
//            if (logEvent.isScriptError) return true;
//        }
//        return false;
//    }
//


//
//    @RequiresApi(api = Build.VERSION_CODES.M)
//    private void saveLogToFile(String jsonString) throws IOException {
//        byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
//        byte[] adr = new byte[]{10, 0, 2, 2};
//        InetAddress address = Inet4Address.getByAddress(adr);
//        Socket socket = new Socket(address, 6580);
//        OutputStream os = socket.getOutputStream();
//        os.write(bytes);
//        os.flush();
//        os.close();
//        socket.close();
//    }


//    public static boolean isExternalStorageWritable() {
//        String state = Environment.getExternalStorageState();
//        if (Environment.MEDIA_MOUNTED.equals(state)) {
//            return true;
//        }
//        return false;
//    }


}
