package ru.yandex.serpbugcatcher.kernel;


import android.webkit.ConsoleMessage;
import android.webkit.PermissionRequest;
import android.webkit.WebChromeClient;
import android.webkit.WebView;

import ru.yandex.serpbugcatcher.kernel.Logger;


public class MyWebChromeClient extends WebChromeClient {

    public final Logger logger;
    private final Boolean[] errorFlag;


    public MyWebChromeClient(Logger logger, Boolean[] errorFlag) {
        super();
        this.logger = logger;
        this.errorFlag = errorFlag;
    }

    @Override
    public void onPermissionRequestCanceled(PermissionRequest request) {
        logger.addInfo("onPermissionRequestCanceled: " + request.toString());
        super.onPermissionRequestCanceled(request);
    }

    @Override
    public void onPermissionRequest(PermissionRequest request) {
        logger.addInfo("onPermissionRequest: " + request.toString());
        super.onPermissionRequest(request);
    }


    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        logger.addInfo("onProgressChanged: " + Integer.toString(newProgress));
        super.onProgressChanged(view, newProgress);
    }


    @Override
    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String message = new StringBuilder()
                .append("lineNumber:")
                .append(consoleMessage.lineNumber())
                .append("; message:")
                .append(consoleMessage.message())
                .append("; messageLevel:")
                .append(consoleMessage.messageLevel())
                .append("; sourceId:")
                .append(consoleMessage.sourceId())
                .toString();
        logger.addScriptError("onConsoleMessage: " + message);
        errorFlag[0] = Boolean.TRUE;
        return super.onConsoleMessage(consoleMessage);
    }


}
