package ru.yandex.serpbugcatcher.kernel;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Message;
import android.support.annotation.RequiresApi;
import android.view.KeyEvent;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import java.net.URL;
import java.util.Arrays;


public class MyWebViewClient extends WebViewClient {


    private final Logger logger;
    private final Boolean[] errorFlag;

    public MyWebViewClient(Logger logger, Boolean[] errorFlag) {
        super();
        this.logger = logger;
        this.errorFlag = errorFlag;
    }


    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        logger.addInfo("onPageStarted=" + url);
        super.onPageStarted(view, url, favicon);
    }

    @Override
    public void onPageFinished(final WebView view, String url) {
        logger.addInfo("onPageFinished=" + url);
        view.evaluateJavascript(
                "(function() { body = document.getElementsByTagName('body')[0]; return body.hasAttribute('data-bem') ? body.getAttribute('data-bem') : ''; })();",
                new ValueCallback<String>() {
                    @Override
                    public void onReceiveValue(String data_bem) {
                        String firstPattern = "\\\"reqid\\\":\\\"";
                        int start = data_bem.indexOf(firstPattern);
                        if (start < 1) return;
                        data_bem = data_bem.substring(start + firstPattern.length());
                        int end = data_bem.indexOf("\\\"");
                        data_bem = data_bem.substring(0, end);
                        logger.setReqid(data_bem);
                    }
                }

        );


        super.

                onPageFinished(view, url);

    }

    @Override
    public void onPageCommitVisible(WebView view, String url) {
        logger.addInfo("onPageFinished=" + url);
        super.onPageCommitVisible(view, url);
    }

    @TargetApi(Build.VERSION_CODES.M)
    @RequiresApi(api = Build.VERSION_CODES.M)
    @Override
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        StringBuilder message = new StringBuilder();
        message.append("method:");
        message.append(request.getMethod());
        message.append("; hasGesture:");
        message.append(Boolean.toString(request.hasGesture()));
        message.append("; isForMainFrame:");
        message.append(Boolean.toString(request.isForMainFrame()));
//         message       .append("; isRedirect:");
//         message       .append(Boolean.toString(request.isRedirect()));
        message.append("; url:");
        message.append((request.getUrl() != null) ? request.getUrl().toString() : "null");
        message.append("; RequestHeaders:");
        message.append((request.getRequestHeaders() != null) ?
                Arrays.toString(request.getRequestHeaders().entrySet().toArray()) :
                "null");
        logger.addNetworkError("onReceivedError: " + message.toString());
        errorFlag[0] = Boolean.TRUE;
        super.onReceivedError(view, request, error);
    }


    @Override
    public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
        logger.addInfo("onReceivedLoginRequest: " + event.toString());
        super.onUnhandledKeyEvent(view, event);
    }

    @Override
    public void onReceivedLoginRequest(WebView view, String realm, String account, String args) {
        logger.addInfo("onReceivedLoginRequest: " + realm + "   " + account + "   " + args);
        super.onReceivedLoginRequest(view, realm, account, args);
    }

    @Override
    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        logger.addNetworkError("onReceivedHttpAuthRequest: " + realm + "   " + handler.toString());
        errorFlag[0] = Boolean.TRUE;
        super.onReceivedHttpAuthRequest(view, handler, host, realm);
    }

    @Override
    public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
        logger.addInfo("onReceivedClientCertRequest: " + request.toString());
        super.onReceivedClientCertRequest(view, request);
    }

    @Override
    public void onScaleChanged(WebView view, float oldScale, float newScale) {
        logger.addInfo("onScaleChanged: " + newScale);
        super.onScaleChanged(view, oldScale, newScale);
    }

    @Override
    public void onLoadResource(WebView view, String url) {
        logger.addInfo("onLoadResource: " + url);
        super.onLoadResource(view, url);
    }

    @Override
    public void onFormResubmission(WebView view, Message dontResend, Message resend) {
        logger.addInfo("onFormResubmission: " + resend.toString());
        super.onFormResubmission(view, dontResend, resend);
    }

    @TargetApi(Build.VERSION_CODES.M)
    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    @Override
    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        StringBuilder message = new StringBuilder();
        message.append("Request { ");
        message.append("method:");
        message.append(request.getMethod());
        message.append("; hasGesture:");
        message.append(request.hasGesture());
        message.append("; isForMainFrame:");
        message.append(request.isForMainFrame());
        message.append("; isRedirect:");
//                .append(request.isRedirect())
        message.append("; url:");
        message.append((request.getUrl() != null) ? request.getUrl().toString() : "null");
        message.append("; requestHeaders:");
        message.append((request.getRequestHeaders() != null) ?
                Arrays.toString(request.getRequestHeaders().entrySet().toArray()) : "null");
        message.append(" } ErrorResponse { ");
        message.append("statusCode:");
        message.append(errorResponse.getStatusCode());
        message.append("; reasonPhrase:");
        message.append(errorResponse.getReasonPhrase());
        message.append(" } ");
        logger.addInfo("onReceivedHttpError: " + message);
        errorFlag[0] = Boolean.TRUE;
        super.onReceivedHttpError(view, request, errorResponse);
    }

    @Override
    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        try {
            String urlString = error.getUrl();
            URL url = new URL(urlString);
            if (!url.getHost().equalsIgnoreCase("www-beta.yandex.ru")
                    && !url.getHost().equalsIgnoreCase("hamster.yandex.ru")) {
                logger.addInfo("onReceivedSslError: " + error.toString());
                errorFlag[0] = Boolean.TRUE;
            }
        } catch (Exception e) {
        }
        handler.proceed();
    }


}
