package ru.yandex.serpbugcatcher.kernel;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.webkit.CookieManager;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.TextView;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import ru.yandex.serpbugcatcher.datalayer.LogSender;
import ru.yandex.serpbugcatcher.model.Query;
import ru.yandex.serpbugcatcher.datalayer.MetricsLayer;

/**
 * Created by ajkon on 16-10-06.
 */


public class SerpLoader implements Runnable {

    public static final String MORDA_REQUEST = "https://www.yandex.ru/";
    public static final String SEARCH_REQUEST = "https://yandex.ru/search/touch/?ajkon=1";
//    public static final String MORDA_REQUEST = "https://www-beta.yandex.ru/";
//    public static final String SEARCH_REQUEST = "https://hamster.yandex.ru/search/touch/?ajkon=1";

    public static final String MORDA_MDA_OFF_REQUEST = MORDA_REQUEST + "?mda=0";
    private final Activity activity;
    private final WebView mWebView;
    private final TextView textView;
    public final Logger logger;
    private final Boolean[] errorFlag;


    private int total = 0;
    private int counter = 0;


    public SerpLoader(Activity activity, WebView mWebView, TextView textView, Logger logger, Boolean[] errorFlag) {
        this.activity = activity;
        this.mWebView = mWebView;
        this.textView = textView;
        this.logger = logger;
        this.errorFlag = errorFlag;
    }

    @RequiresApi(api = Build.VERSION_CODES.M)
    @Override
    public void run() {

        try {
//            String testUrl = openRequest("мама мыла раму", 213);
//            setShowText(testUrl);
//            if (1 == 1) return;
//

            MetricsLayer metricsLayer = new MetricsLayer();
            Query[] queries = metricsLayer.getQueries();
            int iterationSize = 5;
            int iterations = queries.length / iterationSize;
            total = iterations * iterationSize * 2;
            for (int i = 0; i < iterations; i++) {
                Query[] iterationQueries = Arrays.copyOfRange(queries, i * iterationSize, (i + 1) * iterationSize);
                lunchIteration(iterationQueries, false);
                lunchIteration(iterationQueries, true);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lunchIteration(Query[] iterationQueries, boolean isMda0) throws Exception {
        clearCookies();
        setShowText("clear cookies");
        pause(10);
        if (isMda0) {
            setMda0();
            setShowText("set mda=0");
        } else {
            openMorda();
            setShowText("open morda");
        }
        pause(60);
        logger.clear();
        clearCache();
        setShowText("clear cache");
        pause(10);
        logger.setClearCache(true);
        iterationRequests(iterationQueries, isMda0);
    }

    private void iterationRequests(Query[] iterationQueries, boolean isMda0) throws Exception {
        for (int i = 0; i < iterationQueries.length; i++) {
            setShowText("Iteration: "
                    + Integer.toString(counter)
                    + " of " + Integer.toString(total)
                    + "\nError counter: " + Integer.toString(LogSender.getErrorCounter())
                    + "\nIsMDA: " + Boolean.toString(isMda0)
            );
            logger.setIterationQuery(iterationQueries[i]);
            logger.setStartCookies(getCookies());
            logger.setReqid(""); // рекид сбрасываем, он установится асинхронно по мере загрузки страницы
            String url = openRequest(iterationQueries[i].text, iterationQueries[i].regionId);
            logger.setUrl(url);
            addShowText("\nSend request: " + iterationQueries[i].text + "\t" + Integer.toString(iterationQueries[i].regionId));
            pause(180);
            logger.setEndCookies(getCookies());
            if (logger.hasErrors() && logger.hasReqid()) {
                LogSender logSender = new LogSender(logger);
                logSender.sendErrors();
            }
            logger.clear();
            counter++;
        }
    }

    private void setMda0() {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mWebView.loadUrl(MORDA_MDA_OFF_REQUEST);
            }
        });
    }


    private void openMorda() {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mWebView.loadUrl(MORDA_REQUEST);
            }
        });
    }


    private final void pause(int sec) throws InterruptedException {
        Thread.sleep(1000L * (long) sec);
    }


    private final String getCookies() throws InterruptedException {
        final String[] result = new String[1];
        final CountDownLatch latch = new CountDownLatch(1);
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                final CookieManager cookieManager = CookieManager.getInstance();
                result[0] = cookieManager.getCookie(SEARCH_REQUEST + "&lr=213&text=test");
                latch.countDown();
            }
        });
        latch.await();
        return result[0];
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    private final boolean clearCookies() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final Boolean[] result = new Boolean[1];
        result[0] = false;
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                CookieManager.getInstance().removeAllCookies(new ValueCallback<Boolean>() {
                    @Override
                    public void onReceiveValue(Boolean value) {
                        result[0] = value;
                        latch.countDown();
                    }
                });
            }
        });
        latch.await(10, TimeUnit.SECONDS);
        if (result[0]) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    CookieManager.getInstance().flush();
                }
            });
        }

        return result[0];
    }

    private final void clearCache() {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mWebView.clearCache(true);
            }
        });
    }

    private final void openUrl(String url) {
        final String finalUrl = url;
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mWebView.loadUrl(finalUrl);
            }
        });
    }


    private final String openRequest(String request, int lr) throws UnsupportedEncodingException {
        String url = null;
        String encodeRequest = URLEncoder.encode(request, "UTF-8");
        url = encodeRequest = MessageFormat.format(SEARCH_REQUEST + "&lr={0}&text={1}",
                Integer.toString(lr),
                encodeRequest);
        openUrl(url);
        return url;
    }

//
//    private void showLifeCycleLog() {
//        StringBuffer sb = new StringBuffer();
//        sb.append("\nERROR LOG\n");
//        if (errorFlag[0]) {
//            int index = 1;
//            for (Object obj : lifeCycleLog) {
//                sb.append("\n--- step number: " + Integer.toString(index) + " ---\n");
//                sb.append(obj);
//                index++;
//            }
//            addText(sb.toString());
//            lifeCycleLog.clear();
//            errorFlag[0] = Boolean.FALSE;
//        } else {
//            addText("\nok");
//        }
//    }


    private void setShowText(String text) {
        final String finalText = text;
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                textView.setText(finalText);
            }
        });
    }

    private void addShowText(String text) {
        final String finalText = text;
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                textView.setText(textView.getText() + finalText);
            }
        });
    }

}
