package ru.yandex.serpbugcatcher.view;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AppCompatActivity;
import android.text.method.ScrollingMovementMethod;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.TextView;

import ru.yandex.serpbugcatcher.kernel.Logger;
import ru.yandex.serpbugcatcher.kernel.MyWebChromeClient;
import ru.yandex.serpbugcatcher.kernel.MyWebViewClient;
import ru.yandex.serpbugcatcher.R;
import ru.yandex.serpbugcatcher.kernel.SerpLoader;

public class MainActivity extends AppCompatActivity {


    private static Context context;

    private WebView mWebView;
    private TextView textView;
    private final Boolean[] errorFlag = new Boolean[]{Boolean.FALSE};

    private final Logger logger = new Logger();


    @RequiresApi(api = Build.VERSION_CODES.M)
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MainActivity.context = getApplicationContext();
        setContentView(R.layout.activity_main);

        this.textView = (TextView) findViewById(R.id.textView);
        this.textView.setMovementMethod(new ScrollingMovementMethod());


        mWebView = (WebView) findViewById(R.id.webView);
        MyWebViewClient myWebViewClient = new MyWebViewClient(logger, errorFlag);
        mWebView.setWebViewClient(myWebViewClient);
        MyWebChromeClient myWebChromeClient = new MyWebChromeClient(logger, errorFlag);
        mWebView.setWebChromeClient(myWebChromeClient);
        WebSettings settings = mWebView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setDomStorageEnabled(true);

//        mWebView.loadUrl("https://www.yandex.ru/");
//        textView.setText("https://www.yandex.ru/");


        SerpLoader serpLoader = new SerpLoader(this, this.mWebView, this.textView, logger, errorFlag);
        Thread thread = new Thread(serpLoader);
        thread.start();

    }


    public static Context getAppContext() {
        return MainActivity.context;
    }

}
