package com.ajkon.DataLayer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

import static com.ajkon.Settings.getCacheFolder;
import static com.ajkon.Settings.svnContryPriorityPath;
import static java.util.stream.Collectors.toList;


public class CountryPriority {

    public Map<String, Double> getCountryPriority() throws SVNException, IOException {
        final String destPath = getCacheFolder() + "country_priority";
        Path path = Paths.get(destPath);
        if (!Files.exists(path) || !Files.isDirectory(path)) {
            SVNRepository repository = SVNRepositoryFactory.create(SVNURL.parseURIEncoded(svnContryPriorityPath()));
            ISVNAuthenticationManager authManager =
                    SVNWCUtil.createDefaultAuthenticationManager("robot-spok", "whP)EU6p".toCharArray());
            repository.setAuthenticationManager(authManager);
            long latestRevision = repository.getLatestRevision();
//            System.out.println("Repository Latest Revision: " + latestRevision);
            SVNClientManager ourClientManager = SVNClientManager.newInstance();
            ourClientManager.setAuthenticationManager(authManager);
            SVNUpdateClient updateClient = ourClientManager.getUpdateClient();
            updateClient.setIgnoreExternals(false);
            updateClient.doExport(repository.getLocation(), new File(destPath),
                    SVNRevision.create(latestRevision), SVNRevision.create(latestRevision),
                    null, true, SVNDepth.INFINITY);
        }
        Map<String, Double> map = new HashMap<String, Double>();
        for (Path p : Files.list(path).collect(toList())) {
            String key = p.getFileName().toString().toLowerCase();
            double value = Double.parseDouble(Files.readAllLines(p, StandardCharsets.UTF_8).get(0))/100;
            map.put(key, value);
        }
        return map;
    }

}
