package com.ajkon.DataLayer;

import com.ajkon.Model.Cell;
import com.ajkon.Model.RowSettings;
import com.ajkon.Settings;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

import static com.ajkon.Settings.getExcludeCategory;
import static com.ajkon.Settings.getExcludeMetrics;
import static com.ajkon.Utils.Utils.*;

/**
 * Created by ajkon on 16-09-22.
 */
public class SrcParser {


//    public static final long firstStart = Settings.getDefFirststart().getTime();
//    public static final long firstEnd = Settings.getDefFirstEnd().getTime();
//    public static final long secondStart = Settings.getDefSecondStart().getTime();
//    public static final long secondEnd = Settings.getDefSecondEnd().getTime();


    public List<List<Cell>> parse(List<List<String>> listSrcTable,
                                  Map<String, Double> countryPriorityMap)
            throws IOException {
        final String[][] srcTable = listSrcTable.stream()
                .map(i -> i.stream().toArray(size -> new String[size]))
                .toArray(size2 -> new String[size2][]);
        final int colTitleRow = 0;
        final int countCols = listSrcTable.get(colTitleRow).size();
        final int settingsCol = IntStream.range(0, countCols)
                .filter(i -> listSrcTable.get(colTitleRow).get(i).equals("#row_settings"))
                .findAny()
                .getAsInt();
        final int rowTitleCol = IntStream.range(0, countCols)
                .filter(i -> listSrcTable.get(colTitleRow).get(i).equals("Metrics"))
                .findAny()
                .getAsInt();
        final int worldMetricCol = IntStream.range(0, countCols)
                .filter(i -> listSrcTable.get(colTitleRow).get(i).equalsIgnoreCase("World"))
                .findAny()
                .getAsInt();
        final List<List<Cell>> cellTable = new ArrayList<List<Cell>>(srcTable.length);
        String rowCategory = "";
        for (int i = 0; i < srcTable.length; i++) {
            if (i == colTitleRow) continue;
            if (0 == listSrcTable.get(i).stream().filter(l -> (!isNullOrEmpty(l))).count()) continue;
            String rowTitle = srcTable[i][rowTitleCol];
            List<Cell> cellsRow = new ArrayList<Cell>(countCols);
            RowSettings rowSettings = getRowSettings(srcTable[i][settingsCol]);
            if (rowSettings.isCategory != null && rowSettings.isCategory.booleanValue()) {
                rowCategory = rowTitle;
                if (rowCategory.startsWith("**") && rowCategory.endsWith("**")) {
                    rowCategory = rowCategory.substring(2, rowCategory.length() - 2).trim();
                }
                continue;
            }
            final String finalRowCategory = rowCategory;
            boolean isExludeCategory = getExcludeCategory().stream().anyMatch(l -> l.equalsIgnoreCase(finalRowCategory));
            if (isExludeCategory) continue;
            final String finalRowTitle = rowTitle;
            boolean isExludeTitle = getExcludeMetrics().stream().anyMatch(l -> l.equalsIgnoreCase(finalRowTitle));
            if (isExludeTitle) continue;
            boolean recalcWorld = (rowSettings.recalcWorld != null) ? rowSettings.recalcWorld.booleanValue() : false;
            int interval = (rowSettings.interval != null) ? rowSettings.interval.intValue() : Settings.getDefInterval();
            Date firstEnd = (rowSettings.start != null) ? rowSettings.start : Settings.getDefStart();
            Date firstStart = calcTime(firstEnd, -interval);
            Date secondEnd = (rowSettings.end != null) ? rowSettings.end : Settings.getDefEnd();
            Date secondStart = calcTime(secondEnd, -interval);
            for (int j = 0; j < srcTable[colTitleRow].length; j++) {
                if (j == settingsCol) continue;
                if (j == rowTitleCol) {
                    continue;
                }
                String srcValue = srcTable[i][j];
                Cell cell = new Cell();
                cell.columnTitle = srcTable[colTitleRow][j];
                cell.rowTitle = rowTitle;
                cell.link = getFirstUrl(srcValue);
                cell.countryPriority = countryPriorityMap.getOrDefault(cell.columnTitle.toLowerCase(), 0.0);
                cell.rowCategory = rowCategory;
                cell.value = srcTable[i][j];
                cell.isWorldMetrics = (j == worldMetricCol);
                cell.recalcWorld = recalcWorld;
                cell.increaseDirection = rowSettings.increaseDirection;
                cell.valueSelectMethod = rowSettings.valueSelectMethod;
                cell.recalcWorld = rowSettings.recalcWorld;
                cell.calcMethod = rowSettings.calcMethod;
                cell.firstStart = firstStart;
                cell.firstEnd = firstEnd;
                cell.secondStart = secondStart;
                cell.secondEnd = secondEnd;
                cellsRow.add(cell);
            }
            cellTable.add(cellsRow);
        }
        return cellTable;
    }


    private static final YAMLFactory yamlFactory = new YAMLFactory();
    private static final ObjectMapper mapper = new ObjectMapper(yamlFactory);
    private static final Class<RowSettings> rowSettingsClass = RowSettings.class;


    private static final RowSettings getRowSettings(String str) throws IOException {
        String yamlString = trimCommas(str);
        if (yamlString.startsWith("%%")) yamlString = yamlString.substring(2);
        if (yamlString.endsWith("%%")) yamlString = yamlString.substring(0, yamlString.length() - 2);
//        yamlString = yamlString.replace("\\n", "\n");
        RowSettings rowSettings = (yamlString.startsWith("---"))
                ? mapper.readValue(yamlString, rowSettingsClass)
                : new RowSettings();
        return rowSettings;
    }

    private static final URL getFirstUrl(String str) throws MalformedURLException {
        int index = str.indexOf("http");
        if (index == -1) return null;
        String linkStr = str.substring(index);
        index = linkStr.indexOf((char) 32);
        if (index > 0) linkStr = linkStr.substring(0, index);
        URL url = new URL(linkStr);
        return url;
    }


}



