package com.ajkon.DataLayer;


import com.ajkon.Settings;
import com.ajkon.Utils.StreamCache;
import com.ajkon.Utils.Utils;

import javax.json.*;
import javax.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

import static com.ajkon.Utils.Utils.trimCommas;
import static java.util.stream.Collectors.toList;


/**
 * Права:
 * Чтение из Вики
 * Запись в Вики
 * ID: 7b16d496299947d6897b6a373ebbe4d2
 * Пароль: d44fe7a3cc6e47f89bcb7d8448876821
 * Callback URL: https://oauth.yandex-team.ru/verification_code
 * robot-spok token: AQAD-qJSJmq4AAAFtEGkXZMP6kOpihg-y70t9vk
 */
public class WikiLayer {


    public List<List<String>> GetSrcTable() throws Exception {
        String url = Settings.getWikiApi() + Settings.getGridPath() + ".grid?format=json";
        URL theUrl = new URL(url);
        URLConnection connection = theUrl.openConnection();
        connection.addRequestProperty("Authorization", "OAuth " + Settings.getToken());
        connection.addRequestProperty("Content-Type", "application/json");
        try (InputStream inputStream = StreamCache.getInputStream(connection);
             JsonReader jsonReader = Json.createReader(inputStream)) {
            JsonObject jsonAnswer = jsonReader.readObject();
            JsonObject data = jsonAnswer.getJsonObject("data");
            JsonArray fields = data.getJsonObject("structure").getJsonArray("fields");
            JsonArray rowsJsonArray = data.getJsonArray("rows");

            List<String> titleList = fields.stream().map(i -> ((JsonObject) i).getString("title")).collect(toList());
            List<JsonArray> rowsJsonList = rowsJsonArray.stream().map(i -> ((JsonArray) i)).collect(toList());
            List<List<String>> tableLists = rowsJsonList.stream()
                    .map(i -> i.stream()
                            .map(o -> strConvert(((JsonObject) o).get("raw").toString()))
                            .collect(toList()))
                    .collect(toList());
            tableLists.add(0, titleList);

            return tableLists;
        }
    }

    private static final String strConvert(String wikiValue){
        wikiValue = trimCommas(wikiValue);
        wikiValue = wikiValue.replace("\\n", "\n");
        wikiValue = wikiValue.replace("\\\\", "\\");
        return wikiValue;
    }


    public void sendResultToPage(JsonObject jsonObject) throws IOException, ExecutionException {

        if (1 != 1) {
            System.out.println(jsonObject.getString("body"));
        } else {
            StringWriter stringWriter = new StringWriter();
            Map<String, Boolean> config = buildConfig(JsonGenerator.PRETTY_PRINTING);
            JsonWriterFactory writerFactory = Json.createWriterFactory(config);
            JsonWriter jsonWriter = writerFactory.createWriter(stringWriter);
            jsonWriter.writeObject(jsonObject);
            jsonWriter.close();
            String body = stringWriter.toString();
            byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
            String url = Settings.getWikiApi() + Settings.getResultPagePath();
            URL theUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection) theUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.addRequestProperty("Authorization", "OAuth " + Settings.getToken());
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
            connection.setUseCaches(false);
            connection.connect();
            try (OutputStream outputStream = connection.getOutputStream()) {
                outputStream.write(bytes);
                outputStream.flush();
                outputStream.close();
            }
            connection.disconnect();
            int resultCode = connection.getResponseCode();
            if (resultCode != 200) {
                throw new ExecutionException(connection.getResponseMessage(), new Throwable(connection.getResponseMessage()));
            }
        }
    }



    private static Map<String, Boolean> buildConfig(String... options) {
        Map<String, Boolean> config = new HashMap<String, Boolean>();
        if (options != null) {
            for (String option : options) {
                config.put(option, true);
            }
        }
        return config;
    }

}



