package com.ajkon;


import com.ajkon.DataLayer.CountryPriority;
import com.ajkon.DataLayer.SrcParser;
import com.ajkon.DataLayer.WikiLayer;
import com.ajkon.Kernel.Calc;
import com.ajkon.MetricsAdapter.Metrics;
import com.ajkon.MetricsAdapter.Razladki;
import com.ajkon.Model.Cell;
import com.ajkon.Utils.SSLTool;
import com.ajkon.Utils.Utils;
import com.ajkon.View.ViewResult;

import javax.json.JsonObject;
import java.util.List;
import java.util.Map;


/**
 * SPOK report generator
 * генерирует отчёты по метрикам поиска в разных странах
 */
public class Main {


    /**
     * Точка старта программы.
     *
     * @param args Набор параметров командной строки переданный при запуске программы. В данной программе игнорируется и никак не используется.
     */
    public static void main(String[] args) {
        SSLTool.disableCertificateValidation();
        run();
        System.out.println("\n\nDone");
    }


    private static void run() {
        try {
            System.out.print("\nSrc-table reading...");
            WikiLayer wikiLayer = new WikiLayer();
            List<List<String>> srcTable = wikiLayer.GetSrcTable();
            System.out.print("ok\nCountry priority getting...");
            CountryPriority countryPriority = new CountryPriority();
            Map<String, Double> countryPriorities = countryPriority.getCountryPriority();
            System.out.print("ok\nSrc-data parsing...");
            SrcParser srcParser = new SrcParser();
            List<List<Cell>> cells = srcParser.parse(srcTable, countryPriorities);
            System.out.print("ok\nValues getting...");
            fillByExternalData(cells);
            System.out.print("ok\nCalculation...");
            Calc calc = new Calc(cells);
            calc.calcMetrics();
            System.out.print("ok\nSending results...");
            ViewResult viewResult = new ViewResult(cells);
            JsonObject jsonObject = viewResult.getView();
            wikiLayer.sendResultToPage(jsonObject);
            System.out.print("ok\n");
            System.out.println(Settings.getWikiUI() + Settings.getResultPagePath());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private static void fillByExternalData(List<List<Cell>> cells) throws Exception {
        Metrics metrics = new Metrics();
        Razladki razladki = new Razladki();
        //  Handmade handmade = new Handmade();
        for (List<Cell> cellRow : cells) {
            for (Cell cell : cellRow) {
                metrics.fill(cell);
                razladki.fill(cell);
                // handmade.fill(cell);
            }
        }
    }


}


