package com.ajkon.MetricsAdapter;

import com.ajkon.Model.Cell;
import com.ajkon.Settings;
import javafx.util.Pair;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.ajkon.Settings.mskTimeZone;
import static com.ajkon.Utils.Utils.isNullOrEmpty;
import static java.util.stream.Collectors.toList;

/**
 * Created by ajkon on 16-09-26.
 */
public class Handmade implements ExtDataFiller {


    private static final String startFile = "start.csv";
    private static final String linkFile = "link.csv";
    private static final String endFile = "end.csv";


    private final List<HandmadeCell> startHandmadeCells;
    private final List<HandmadeCell> linkHandmadeCells;
    private final List<HandmadeCell> endHandmadeCells;


    private class HandmadeCell {
        String value;
        String columnTitle;
        String rowTitle;
        boolean isValue = false;
    }

    public Handmade() throws IOException {
        startHandmadeCells = getHandmadeCell(startFile);
        linkHandmadeCells = getHandmadeCell(linkFile);
        endHandmadeCells = getHandmadeCell(endFile);
    }

    private List<HandmadeCell> getHandmadeCell(String fileName) throws IOException {
        Path path = Paths.get(Settings.getHandmadeFolder() + fileName);
        if (!Files.exists(path)) {
            return new ArrayList<HandmadeCell>();
        }
        List<List<HandmadeCell>> tableHandCells;
        try (InputStream inputStream = Files.newInputStream(path);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader)) {
            Stream<String> allLines = bufferedReader.lines();
            Stream<List<HandmadeCell>> rowHandCells = allLines.map(line -> Arrays.stream(line.split(";"))
                    .map(e -> {
                        HandmadeCell h = new HandmadeCell();
                        h.value = e.trim();
                        return h;
                    }).collect(Collectors.toList()));
            tableHandCells = rowHandCells.collect(Collectors.toList());
        }
        for (int i = 1; i < tableHandCells.size(); i++) {
            for (int j = 1; j < tableHandCells.get(0).size(); j++) {
                HandmadeCell handmadeCell = tableHandCells.get(i).get(j);
                handmadeCell.columnTitle = tableHandCells.get(0).get(j).value;
                handmadeCell.rowTitle = tableHandCells.get(i).get(0).value;
                handmadeCell.isValue = true;
            }
        }
        List<HandmadeCell> handmadeCells = tableHandCells.stream()
                .flatMap(i -> i.stream())
                .filter(i -> i.isValue)
                .collect(toList());
        return handmadeCells;
    }


    @Override
    public void fill(Cell cell) throws IOException, ParseException {
        HandmadeCell startHandmadeCell = getHandCell(startHandmadeCells, cell);
        if (startHandmadeCell != null && !isNullOrEmpty(startHandmadeCell.value)) {
            String startValueStr = startHandmadeCell.value.replace(',', '.');
            double startValue = Double.parseDouble(startValueStr);
            Pair<Date, Double> startHandData = new Pair<Date, Double>(handDate(cell.firstEnd), startValue);
            cell.yData.add(startHandData);
            cell.isMetrics = true;
        }
        HandmadeCell linkHandmadeCell = getHandCell(linkHandmadeCells, cell);
        if (linkHandmadeCell != null && !isNullOrEmpty(linkHandmadeCell.value)) {
            cell.link = new URL(linkHandmadeCell.value);
        }
        HandmadeCell endHandmadeCell = getHandCell(endHandmadeCells, cell);
        if (endHandmadeCell != null && !isNullOrEmpty(endHandmadeCell.value)) {
            String endValueStr = endHandmadeCell.value.replace(',', '.');
            double endValue = Double.parseDouble(endValueStr);
            Pair<Date, Double> endHandData = new Pair<Date, Double>(handDate(cell.secondEnd), endValue);
            cell.yData.add(endHandData);
            cell.isMetrics = true;
        }
    }

    private HandmadeCell getHandCell(List<HandmadeCell> handmadeCellList, Cell cell) {
        HandmadeCell handmadeCell = handmadeCellList.stream()
                .filter(i -> (i.rowTitle.equalsIgnoreCase(cell.rowTitle)
                        && i.columnTitle.equalsIgnoreCase(cell.columnTitle)))
                .findFirst().orElse(null);
        return handmadeCell;
    }


    public static final Date handDate(Date date) {
        GregorianCalendar gc = new GregorianCalendar(mskTimeZone);
        gc.setTime(date);
        gc.set(Calendar.MILLISECOND, 0);
        gc.add(Calendar.SECOND, -1);
        Date firstDate = gc.getTime();
        return firstDate;
    }


}
