package com.ajkon.MetricsAdapter;


import com.ajkon.Model.CalcMethod;
import com.ajkon.Model.Cell;
import com.ajkon.Utils.Utils;
import com.ajkon.Utils.*;
import javafx.util.Pair;

import javax.json.*;
import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

import static java.util.stream.Collectors.toList;

/**
 * Created by ajkon on 16-09-24.
 */
public class Metrics implements ExtDataFiller {

    @Override
    public void fill(Cell cell) throws IOException, ParseException {
        if (cell.link == null || !cell.link.getHost().equalsIgnoreCase("metrics.yandex-team.ru")) return;
        cell.isMetrics = true;
        URL url = cell.link;

        URLConnection connection = url.openConnection();
        StringBuilder sb = new StringBuilder();
        try (InputStream inputStream = StreamCache.getInputStream(connection);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader)) {
            for (String str = bufferedReader.readLine(); str != null; str = bufferedReader.readLine()) {
                sb.append(str);
            }
        }
        fixLink(cell);
        JsonObject rootJsonObject = getJson(sb.toString());
        Map<String, List<String>> params = Utils.splitQuery(url.getQuery());
        List<String> urlSystems = Arrays.stream(params.get("systems").get(0).split("\\*"))
                .filter(k -> (!k.equalsIgnoreCase("on")))
                .collect(toList());
        JsonArray systemsJsonArray = rootJsonObject.getJsonArray("systems");
        class System {
            System(int index, String name, String title) {
                this.index = index;
                this.name = name;
                this.title = title;
            }

            final int index;
            final String name;
            final String title;
            Boolean isGoogle;
        }
        List<System> dataSystems = IntStream.range(0, systemsJsonArray.size())
                .mapToObj(i ->
                        new System(i, systemsJsonArray.getJsonObject(i).getString("name")
                                , systemsJsonArray.getJsonObject(i).getString("title")))
                .flatMap(s -> urlSystems.stream()
                        .filter(n -> n.equals(s.name))
                        .map(n -> s)
                )
                .collect(toList());
        dataSystems.forEach(i -> i.isGoogle = (i.title.startsWith("G")));
        if (dataSystems.stream().filter(d -> !d.isGoogle).count() == 0) {
            java.lang.System.out.println("ОШИБКА!!! В данных страницы не найдена метрика из URL:");
            java.lang.System.err.println(url.getQuery());
        }
        final int yandexDataIndex = dataSystems.stream().filter(d -> !d.isGoogle).map(d -> d.index).findFirst().get().intValue();
        final int googleDataIndex = cell.calcMethod.equals(CalcMethod.YandexVsGoogle)
                ? dataSystems.stream()
                .filter(d -> d.isGoogle)
                .map(d -> d.index)
                .findFirst().orElse(-1).intValue()
                : -1;
        JsonObject dataJsonObject = rootJsonObject.getJsonObject("data");
        class DateValue {
            DateValue(Date date, JsonValue values) {
                this.date = date;
                this.value = values;
            }

            final Date date;
            final JsonValue value;
        }
        List<DateValue> dataArray = new ArrayList<DateValue>(dataJsonObject.size());
        dataJsonObject.forEach((k, v) ->
                dataArray.add(new DateValue(strDateToLong(k), ((JsonObject) v).getJsonArray("point"))));
        cell.yData = dataArray.stream().filter(d -> (d.date.getTime() > cell.firstStart.getTime()))
                .filter(f -> (f.value.getValueType().equals(JsonValue.ValueType.ARRAY)
                        && ((JsonArray) f.value).size() > yandexDataIndex))
                .map(i -> new DateValue(i.date, ((JsonArray) i.value).get(yandexDataIndex)))
                .filter(a -> a.value.getValueType().equals(JsonValue.ValueType.OBJECT))
                .map(n -> new Pair<Date, Double>(n.date, Double.parseDouble(((JsonObject) n.value).getString("value"))))
                .collect(toList());
        if (googleDataIndex >= 0) {
            cell.gData = dataArray.stream().filter(d -> (d.date.getTime() > cell.firstStart.getTime()))
                    .filter(f -> (f.value.getValueType().equals(JsonValue.ValueType.ARRAY)
                            && ((JsonArray) f.value).size() > googleDataIndex))
                    .map(i -> new DateValue(i.date, ((JsonArray) i.value).get(googleDataIndex)))
                    .filter(a -> a.value.getValueType().equals(JsonValue.ValueType.OBJECT))
                    .map(n -> new Pair<Date, Double>(n.date, Double.parseDouble(((JsonObject) n.value).getString("value"))))
                    .collect(toList());
        }
    }


    private static final String patternLink = "(?<p1>&data-table=1)";
    private static final Pattern regexLink = Pattern.compile(patternLink);

    private static final void fixLink(Cell cell) throws MalformedURLException {
        String linkString = cell.link.toString();
        Matcher matcher = regexLink.matcher(linkString);
        linkString = matcher.replaceAll("");
        cell.link = new URL(linkString);
    }

    private static final String pattern0 = "(?<p1>\\[)(?<p2>[^\\{\\}\\[\\]\\:\\,]+)(?<p3>\\])";
    private static final String replace0 = "${p1} ${p2} ${p3}";
    private static final Pattern regex0 = Pattern.compile(pattern0);
    private static final String pattern1 = "(?<p1>[\\{\\}\\[\\]\\:\\,])(?<p2>\\w+)(?<p3>[\\{\\}\\[\\]\\:\\,])";
    private static final String replace1 = "${p1}'${p2}'${p3}";
    private static final Pattern regex1 = Pattern.compile(pattern1);

    private static JsonObject getJson(String src) {
        String beforeJson = "<script type=\"text/javascript\">var data = ";
        int startJson = src.indexOf(beforeJson);
        int endJson = src.indexOf("};var", startJson);
        String jsonPart = src.substring(startJson + beforeJson.length(), endJson + 1);
        Matcher matcher = regex0.matcher(jsonPart);
        jsonPart = matcher.replaceAll(replace0);
        matcher = regex1.matcher(jsonPart);
        jsonPart = matcher.replaceAll(replace1);
        matcher = regex1.matcher(jsonPart); //  это не ошибка, применяем регулярку два раза
        jsonPart = matcher.replaceAll(replace1);
        jsonPart = jsonPart.replace("'", "\"");
        JsonObject jo;
        try (JsonReader jsonReader = Json.createReader(new StringReader(jsonPart))) {
            jo = jsonReader.readObject();
        }
        return jo;
    }

    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    private final static Date strDateToLong(String str) {
        try {
            return dateFormat.parse(Utils.trimCommas(str));
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}
