package com.ajkon.MetricsAdapter;


import com.ajkon.Model.Cell;
import com.ajkon.Utils.StreamCache;
import com.ajkon.Utils.Utils;
import javafx.util.Pair;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


public class Razladki implements ExtDataFiller {

    @Override
    public void fill(Cell cell) throws IOException, ParseException {
        if (cell.link == null || !cell.link.getHost().equalsIgnoreCase("razladki.yandex-team.ru")) return;
        cell.isMetrics = true;
        linkCrutches(cell);
        URL url = cell.link;
        String path = url.getPath();
        String ref = url.getRef();
        Map<String, List<String>> params = Utils.splitQuery(ref);
        String metricName = params.get("param").get(0);
        String browserLink = MessageFormat.format("https://razladki.yandex-team.ru{0}#ts_from={1}&ts_to={2}&smooth=1&param={3}",
                path,
                decimalFormat.format(cell.firstStart.getTime()),
                decimalFormat.format(cell.secondEnd.getTime()),
                metricName
        );
        cell.link = new URL(browserLink);
        String dataLink = MessageFormat.format("https://razladki.yandex-team.ru{0}/download/?param={1}&ts_from={2}&ts_to={3}&format=csv",
                path,
                metricName,
                URLEncoder.encode(dateFormat.format(cell.firstStart), "UTF-8"),
                URLEncoder.encode(dateFormat.format(cell.secondEnd), "UTF-8")
        );
        URL theUrl = new URL(dataLink);
        URLConnection connection = theUrl.openConnection();
        try (InputStream inputStream = StreamCache.getInputStream(connection);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader)) {
            cell.yData = bufferedReader.lines()
                    .skip(1) // пропускаем первую строку с заголовками
                    .map(line -> line.split(";"))
                    .map(e -> new Pair<Date, Double>(strDateToDate(e[0]), Double.parseDouble(e[1])))
                    .collect(Collectors.toList());
        }

    }

    private static final DecimalFormat decimalFormat = new DecimalFormat("#############");


    private void linkCrutches(Cell cell) throws MalformedURLException {
        String linkString = cell.link.toString();
        linkString = linkString.replace("/surplus_fast#", "/surplus#");
        cell.link = new URL(linkString);
    }


    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Date strDateToDate(String str) {
        try {
            return dateFormat.parse(Utils.trimCommas(str));
        } catch (ParseException e) {
            e.printStackTrace();
            return new Date(-1);
        }
    }


    public static long strDateToLong(String str) {
        return strDateToDate(str).getTime();
    }


}
