package com.ajkon;

import java.time.LocalDate;
import java.time.Month;
import java.util.*;

public final class Settings {


    /**
     * Начало периода за который считаем метрики. От этого периода будет отнят _defStart что-бы получить интервал изкоторого выбираем значение метрики для рассчёта.
     */
    private final static LocalDate _start = LocalDate.of(2016, Month.OCTOBER, 1);


    /**
     * Конец периода за который считаем метрики. От этого периода будет отнят _defStart что-бы получить интервал изкоторого выбираем значение метрики для рассчёта.
     */
    private final static LocalDate _end = LocalDate.of(2016, Month.NOVEMBER, 9);


    private final static int _defInterval = 14;


    private static Date _defStart = null;

    public static final Date getDefStart() {
        if (_defStart == null) {
            GregorianCalendar gc = new GregorianCalendar(mskTimeZone);
            gc.set(_start.getYear(), _start.getMonthValue() - 1, _start.getDayOfMonth(), 0, 0, 0); // -1 это не минус месяц а просто приведение от человеческого формата к Zero-based.
            gc.set(Calendar.MILLISECOND, 0);
            _defStart = gc.getTime();
        }
        return _defStart;
    }


    private static Date _defEnd = null;

    public static final Date getDefEnd() {
        if (_defEnd == null) {
            GregorianCalendar gc = new GregorianCalendar(mskTimeZone);
            gc.set(Calendar.HOUR, -24 * 14);
            gc.set(_end.getYear(), _end.getMonthValue() - 1, _end.getDayOfMonth(), 0, 0, 0);  // -1 это не минус месяц а просто приведение от человеческого формата к Zero-based.
            gc.set(Calendar.MILLISECOND, 0);
            _defEnd = gc.getTime();
        }
        return _defEnd;
    }


    public static final int getDefInterval() {
        return _defInterval;
    }

    public final static TimeZone mskTimeZone = TimeZone.getTimeZone("Europe/Moscow");

    public static final String getWikiApi() {
        return "https://wiki-api.yandex-team.ru/_api/frontend";
    }

    public static final String getWikiUI() {
        return "https://wiki.yandex-team.ru";
    }

    public static final String svnContryPriorityPath() {
        return "https://arcadia.yandex.ru/arc/trunk/arcadia/quality/spok/content/common/country_priority";
    }


    // https://wiki.yandex-team.ru/jandekspoisk/kachestvopoiska/gdi/dashboard/generator/srclinks/

    public static final String getGridPath() {
//        return "/jandekspoisk/kachestvopoiska/GDI/integralmetrics2016-Q2Q3/table/";
        return "/jandekspoisk/kachestvopoiska/gdi/dashboard/generator/srclinks/";
    }


    public static final String getResultPagePath() {
//        return "/jandekspoisk/kachestvopoiska/GDI/integralmetrics2016-10/autopage-beta";
//        return "/jandekspoisk/kachestvopoiska/GDI/integralmetrics2016-Q2Q3/autopage-beta2";
//        return "/jandekspoisk/kachestvopoiska/GDI/integralmetrics2016-Q2Q3/autopage";
        return "/jandekspoisk/kachestvopoiska/gdi/dashboard/generator/reports/2016-10";
    }

    public static final String getToken() {
        return "AQAD-qJSJmq4AAAFtEGkXZMP6kOpihg-y70t9vk";
    }

    public static final String getCacheFolder() {
        return "/Users/ajkon/Downloads/temp/";
    }

    public static final String getHandmadeFolder() {
        return "/Users/ajkon/Yandex.Disk.localized/Yandex/Data/Src/ReportGenerator/handMade/";
    }


//    private static final List<String> _showColumns = Arrays.asList("Metrics", "World", "RU", "TR", "UA", "BY", "KZ", "FAQ");
//
//    public static final List<String> getShowColumns() {
//        return _showColumns;
//    }

    //    private static final List<String> _excludeMetrics = Arrays.asList("adult-10 (Y/G)");
    private static final List<String> _excludeMetrics = Arrays.asList();

    public static final List<String> getExcludeMetrics() {
        return _excludeMetrics;
    }


    private static final List<String> _excludeCategory = Arrays.asList("Объектный ответ");

    public static final List<String> getExcludeCategory() {
        return _excludeCategory;
    }


    public static final String getRazladkiApi() {
        return "https://razladki.yandex-team.ru/surplus/download/";
    }


}
