package com.ajkon.Utils;

import com.ajkon.Settings;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

/**
 * Created by ajkon on 16-09-24.
 */
public class StreamCache {


    public static InputStream getInputStream(URLConnection connection) throws IOException {
        URL url = connection.getURL();
        StringBuilder sb = new StringBuilder();
        sb.append(url.getHost().replace('.', '_'));
        sb.append(url.getPath().replace('.', '_').replace('/', '_'));
        Utils.splitQuery(url.getQuery()).values().forEach(i -> i.forEach(j -> sb.append("_" + j)));
        String fileName = sb.toString();
        Path path = Paths.get(Settings.getCacheFolder() + fileName);
        if (Files.exists(path)) {
            return Files.newInputStream(path);
        }
        try (InputStream inputStream = connection.getInputStream()) {
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        return Files.newInputStream(path);
    }

}



