package com.ajkon.Utils;

import com.ajkon.Settings;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.*;

/**
 * Created by ajkon on 16-09-23.
 */
public class Utils {

    public static boolean isNullOrEmpty(String a) {
        return a == null || a.isEmpty();
    }


    public static Map<String, List<String>> splitQuery(String query) throws UnsupportedEncodingException {
        final Map<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
        if (Utils.isNullOrEmpty(query)) return query_pairs;
        final String[] pairs = query.split("&");
        for (String pair : pairs) {
            final int idx = pair.indexOf("=");
            final String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!query_pairs.containsKey(key)) {
                query_pairs.put(key, new LinkedList<String>());
            }
            final String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            query_pairs.get(key).add(value);
        }
        return query_pairs;
    }


    public static String trimCommas(String str) {
        if (str == null || str.isEmpty()) return str;
        str = str.trim();
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        str = str.trim();
        return str;
    }

    public static final Date calcTime(Date date, int changeDayInterval) {
        GregorianCalendar gc = new GregorianCalendar(Settings.mskTimeZone);
        gc.setTime(date);
        gc.set(Calendar.MILLISECOND, 0);
        gc.add(Calendar.HOUR, changeDayInterval * 24);
        Date changeDate = gc.getTime();
        return changeDate;
    }
}
