package com.ajkon.View;

import com.ajkon.Kernel.IncreaseDirection;
import com.ajkon.Model.CalcMethod;
import com.ajkon.Model.Cell;
import com.ajkon.Settings;
import com.ajkon.View.ResultDictionary;
import org.omg.CORBA.Object;

import java.net.URL;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.*;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import java.text.SimpleDateFormat;

import static com.ajkon.Utils.Utils.calcTime;
import static com.ajkon.Utils.Utils.isNullOrEmpty;
import static java.util.stream.Collectors.toList;

/**
 * Created by ajkon on 16-09-26.
 */
public class ViewResult {


    private final List<List<Cell>> cells;


    private final Map<String, Object> showColumnMap = new HashMap<String, Object>();

    private StringBuilder sb;

    public ViewResult(List<List<Cell>> cells) {
        this.cells = cells;
        this.sb = new StringBuilder();
//        Settings.getShowColumns().stream().forEach(l -> showColumnMap.put(l.toLowerCase(), null));
    }


    public JsonObject getView() {
        this.sb = new StringBuilder();
        createBody();
        JsonObject jsonObject = Json.createObjectBuilder()
                .add("title", getTitle())
                .add("body", sb.toString())
                .build();
        return jsonObject;
    }


    private String getTitle() {
        String title = "Отчет построен по данным за период: "
                + dateFormat.format(calcTime(Settings.getDefStart(), -Settings.getDefInterval()))
                + " - "
                + dateFormat.format(calcTime(Settings.getDefEnd(), -1));
        return title;
    }


    private final void createBody() {
        fillMetricValues();
        fillFaq();
        sb.append("{{TOC}}\n");
        List<String> categoryList = cells.stream()
                .flatMap(l -> l.stream())
                .map(l -> l.rowCategory)
                .filter(l -> (!isNullOrEmpty(l)))
                .distinct()
                .collect(toList());
        categoryList.stream().forEach(l -> printCategory(l));
    }

    private final void fillMetricValues() {
        cells.stream()
                .flatMap(i -> i.stream())
                .filter(j -> (j.isMetrics != null && j.isMetrics))
                .forEach(k -> createValue(k));

    }

    private static final DecimalFormat decimalFormat = new DecimalFormat("#########0.00");


    private final void createValue(Cell cell) {
        if (cell.isMetrics == null || !cell.isMetrics) return;
        cell.value = "";
        boolean hasResult = (cell.result != null && !cell.result.isNaN());
        if (!hasResult) {
            cell.value = linkAndValue(cell.link, "-");
            return;
        }
        boolean isPositiveValue = (cell.result > 0.0);
        boolean isZero = (cell.result == 0.0);
        String colorValue = "";
        if (!isZero) {
            boolean moreIsBetter = cell.increaseDirection.equals(IncreaseDirection.MoreBetter);
            if (isPositiveValue == moreIsBetter) {
                colorValue = "!!(green)▲!!";
            } else {
                colorValue = "!!(red)▼!!";
            }
        }
        String strResult = decimalFormat.format(cell.result);
        if (isPositiveValue) strResult = "+" + strResult;
        if (cell.calcMethod.equals(CalcMethod.DeltaPercentage) || cell.calcMethod.equals(CalcMethod.YandexVsGoogle))
            strResult += "%";
        cell.value = colorValue + linkAndValue(cell.link, strResult);
    }

    private String linkAndValue(URL link, String value) {
        if (link == null) return value;
        return "((" + link.toString() + " " + value + "))";
    }


    private final void printCategory(String category) {


        sb.append("\n==");
        sb.append(category);
        sb.append("==\n");
        sb.append("#|\n|| Metrics | ");
//        sb.append("#|\n|| ");
        sb.append(cells.get(0).stream()
                .map(l -> l.columnTitle)
                .collect(Collectors.joining(" | ")));
        sb.append(" ||\n");
        List<List<Cell>> categoryTable = cells.stream()
                .filter(l -> l.get(0).rowCategory.equals(category))
                .collect(toList());
        for (List<Cell> row : categoryTable) {
            sb.append("|| ");
            sb.append(row.get(0).rowTitle);
            if (row.get(0).calcMethod.equals(CalcMethod.DeltaAbsoluteMilli)) {
                sb.append(" x1000");
            }
            sb.append(" | ");
            String rowString = row.stream()
//                    .filter(l -> showColumnMap.containsKey(l.columnTitle.toLowerCase()))
                    .map(c -> c.value)
                    .collect(Collectors.joining(" | "));
            sb.append(rowString);
            sb.append(" ||\n");
        }
        sb.append("|#\n");
    }

    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");


    private final void fillFaq() {
        cells.stream()
                .flatMap(i -> i.stream())
                .filter(j -> j.columnTitle.equalsIgnoreCase("FAQ"))
                .forEach(k -> updateFaq(k));
    }

    private static final void updateFaq(Cell cell) {
        String calcMethod = cell.calcMethod.toString();
        String valueSelectMethod = cell.valueSelectMethod.toString();
        String key = calcMethod + "_" + valueSelectMethod;
        String calcMethodValue = ResultDictionary.dict.get(key);
        cell.value = cell.value.replace("$row_settings:calcMethod$", calcMethodValue);
        String periodComment = MessageFormat.format("---Начальный период: [{0}; {1}) ---Конечный период: [{2}; {3})",
                dateFormat.format(cell.firstStart),
                dateFormat.format(cell.firstEnd),
                dateFormat.format(cell.secondStart),
                dateFormat.format(cell.secondEnd)
        );
        cell.value = cell.value.replace("}>", periodComment + " }>");
    }

}
