#!/usr/bin/env python
# coding: utf-8

import os
import sys
import json
import subprocess
from pprint import pprint

from threading  import Thread
from Queue import Queue, Empty


def enqueue_output(out, queue):
    for line in iter(out.readline, b''):
        queue.put(line)
    out.close()


def main(*args):
    in1, in2, in3, token, any_param, html_file = args

    begemot_cmd = './web/daemons/begemot/begemot --data search/begemot/data/Wizard/search/wizard/data/wizard --port 12345'
    print begemot_cmd

    p = subprocess.Popen(begemot_cmd.split(), stdin=None, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, shell=False)

    q = Queue()
    t = Thread(target=enqueue_output, args=(p.stdout, q))
    t.daemon = True # thread dies with the program
    t.start()

    while True:
        try:
            line = q.get(timeout=1)
        except Empty:
            pass
            #print('no output yet')
        else:
            #print 'get line: {}'.format(line)
            if 'Started on port' in line:
                print line
                break

    with open('./web/daemons/begemot/test/cgi_contexts/test_context.json') as f:
        test_context = json.load(f)

    cmd = './apphost/tools/servant_client/servant_client 127.0.0.1:12345 ./test_context.json'

    for item in in1:
        query = item['expansion']
        print 'Get begemot data for "{}"'.format(query.encode('utf-8'))
        test_context[0]['results'][0]['params']['text'][0] = query
        test_context[0]['results'][1]['text'] = query
        test_context[0]['results'][1]['user_text'] = query
        with open('./test_context.json', 'w') as f:
            json_string = json.dumps(test_context, ensure_ascii=False, indent=4).encode('utf8')
            f.write(json_string)

        p2 = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=None)
        data = p2.stdout.read()
        item['begemot_data'] = json.loads(data)
        yield item
