PRAGMA yt.InferSchema;
USE arnold;

-- TODO: parameters support HITMANSUP-2329
-- DECLARE $day AS String;

$date_to_string = ($source_date) -> {
    RETURN DateTime::ToStringFormat(DateTime::TimestampFromString($source_date), "%Y-%m-%d")
};

-- считаем дату за "неделю назад"
$date = DateTime::ToStringFormat(DateTime::TimestampFromStringFormat($day, "%Y-%m-%d") - DateTime::IntervalFromDays(7), "%Y-%m-%d");

SELECT 
    question_id,
    question_title,
    category_slug
FROM (
    SELECT 
        CAST(q.id as String) as question_id,
        CAST(q.title as String) as question_title,
        qc.category_id as category_slug
    FROM [//home/answers/pg_dumps/production/latest/answers__questions] as q
    INNER JOIN [//home/answers/pg_dumps/production/latest/answers__question_categories] as qc ON qc.question_id == q.id
    WHERE
        q.status == 0
        AND $date_to_string(q.created) >= $date
        AND $date_to_string(q.created) < $day
        AND Yson::ConvertToBool(q.features.is_confident_category) IS NULL
)
ORDER BY RANDOM(question_id)
LIMIT 1000