#!/usr/bin/env python
# -*- coding: utf-8 -*-

import time
import requests
from datetime import timedelta, date


def daterange(start_date, end_date):
    for n in range(int ((end_date - start_date).days)):
        yield start_date + timedelta(n)


def run_yql_query(query, token):
    headers = {
        'Content-Type': 'application/json',
        'Authorization': 'OAuth {}'.format(token)
    }
    r = requests.post(
        'https://yql.yandex.net/api/v2/operations',
        json={
            'content': query,
            'action': 'RUN',
            'type': 'SQL'
        },
        headers=headers
    )
    operation_id = r.json()['id']
    status = r.json()['status']
    tries = 0
    while status in {'PENDING', 'RUNNING'} and tries < 60:
        r = requests.get(
            'https://yql.yandex.net/api/v2/operations/{}'.format(operation_id),
            headers=headers
        )
        status = r.json()['status']
        print 'status: {}, tries: {}'.format(status, tries)
        if status == 'COMPLETED':
            break

        time.sleep(10)
        tries += 1

    if status != 'COMPLETED':
        print 'operation {} failed: {}'.format(operation_id, r.content)
    else:
        r = requests.get(
            'https://yql.yandex.net/api/v2/operations/{}/results?filters=DATA'.format(operation_id),
            headers=headers
        )
        print 'Done, results: "{}"'.format(r.json())
        return r.json()['data'][0]['Write'][0]['Data']
