#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Прокачать график по всем дням в прошлое

from helpers import run_yql_query, daterange


def get_answering_times(token):
    with open('questions_answering_time/get_questions_answering_time.yql') as f:
        yql_query = f.read()

    return run_yql_query(yql_query, token)


def to_number(value):
    try:
        return int(value)
    except ValueError:
        try:
            return float(value)
        except ValueError:
            return value

cols = [
    'fielddate',
    'questions_count',
    'percentage_60m',
    'percentage_120m',
    'percentage_180m',
    'percentage_360m',
    'percentage_720m',
    'percentage_1440m',
    'percentage_2880m',
    'percentage_unanswered_1d',
    'percentage_unanswered_2d',
    'questions_answered_by_60m',
    'questions_answered_by_120m',
    'questions_answered_by_180m',
    'questions_answered_by_360m',
    'questions_answered_by_720m',
    'questions_answered_by_1440m',
    'questions_answered_by_2880m',
    'questions_unanswered_by_1d',
    'questions_unanswered_by_2d'
]

def get_answering_times_result(token):
    data = get_answering_times(token)
    if not data:
        return

    for row in data:
        result = {}
        print row

        for idx, col in enumerate(cols):
            val = row[idx][0] if isinstance(row[idx], list) else row[idx]
            result[col] = to_number(val)

        print(result)
        yield result
