#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import defaultdict
from helpers import run_yql_query

TRUST_LEVELS = {
    0: 'syntetic',
    1: 'organic',
    2: 'km',
    3: 'km',
    4: 'organic',
    5: 'partners',
    6: 'km',
}


def get_users_count_with_1_content(token):
    with open('writers_core/get_users_count_with_1_content.yql') as f:
        yql_query = f.read()

    data = run_yql_query(yql_query, token)
    if data:
        for row in data:
            # fielddate, status, count
            yield row[0][0], TRUST_LEVELS[int(row[1][0])], int(row[2])


def get_users_count_with_3_content_per_week(token):
    with open('writers_core/get_users_count_with_3_content_per_week.yql') as f:
        yql_query = f.read()

    data = run_yql_query(yql_query, token)
    if data:
        for row in data:
            # fielddate, status, count
            yield row[0][0], TRUST_LEVELS[int(row[1][0])], int(row[2])


def get_writers_core(token):
    results = defaultdict(dict)

    data = defaultdict(float)
    for row in get_users_count_with_1_content(token):
        data[(row[0], row[1])] += row[2]
        data[(row[0], 'all')] += row[2]
    for k, v in data.items():
        results[k].update({
            'fielddate': k[0],
            'user_type': k[1],
            'users_count_with_1_content': v,
        })

    data = defaultdict(float)
    for row in get_users_count_with_3_content_per_week(token):
        data[(row[0], row[1])] += row[2]
        data[(row[0], 'all')] += row[2]
    for k, v in data.items():
        results[k].update({
            'fielddate': k[0],
            'user_type': k[1],
            'users_count_with_3_content_per_week': v,
        })

    return results.values()
