#!/usr/bin/env python
# coding: utf-8

"""
на самом деле, можно даже за время, пропорциональное k * n, где k - это количество непохожих векторов, которые ты хочешь выбрать, а n - это количество векторов всего.
Делаешь массив distance размера n, где для каждого вектора ты хранишь расстояние до самого близкого объекта из выбранных в ответ. Сначала distance[a] = infinity для всех объектов.
Первым вектором берешь случайный, distance[i] для всех i это теперь расстояние до него.
Дальше на каждой итерации берешь такой j, у которого distance[j] максимальный - это самый непохожий вектор на уже имеющиеся и добавляешь его в ответ.
После этого distance[i] для всех i можно пересчитать за один проход(это либо уже текущий distance[i], либо расстояние до нового объекта(то, что меньше))
"""

import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import os
import json
import random
import itertools
from scipy import spatial
from datetime import date, datetime
from collections import defaultdict

NEED_QUERIES = 100

def main(*args):
    queries_list, in2, in3, token, any_param, html_file = args

    total_queries = len(queries_list)

    distance = [1] * total_queries
    result = []

    result.append(random.choice(queries_list))
    for idx, d in enumerate(distance):
        distance[idx] = spatial.distance.cosine(queries_list[idx]['embed'], result[0]['embed'])

    for i in range(NEED_QUERIES - 1):
        max_distance = 0
        max_distance_idx = None
        for idx, d in enumerate(distance):
            if d > max_distance:
                max_distance = d
                max_distance_idx = idx

        best_item = queries_list[max_distance_idx]
        result.append(best_item)

        print '{}), max_dist: {}, get query: {}'.format(i, max_distance, best_item)

        for idx, d in enumerate(distance):
            distance[idx] = min(spatial.distance.cosine(queries_list[idx]['embed'], best_item['embed']), distance[idx])

    return result
