# -*- coding: utf-8 -*-
from __future__ import unicode_literals, print_function

from collections import defaultdict
from datetime import datetime as _datetime
import six


def date(strdate):
    try:
        return _datetime.strptime(strdate, '%Y-%m-%d').date()
    except ValueError:
        # sometimes smth like 0000-00-00 happens
        # and conversion fails
        if strdate == '0000-00-00':
            return _datetime.fromtimestamp(0).date()
        else:
            # cot covered case - panic
            raise


def datetime(strdatetime):
    try:
        return _datetime.strptime(strdatetime, '%Y-%m-%d %H:%M:%S')
    except ValueError:
        if strdatetime == '0000-00-00 00:00:00':
            return _datetime.fromtimestamp(0)
        else:
            # panic
            raise


def num(type_):
    def save_convert(obj):
        try:
            return type_(obj)
        except TypeError:
            # nans are represented as None
            # it can be a result of 1/0
            if obj is None:
                return float('nan')
            # not covered case - panic
            else:
                raise
    return save_convert


def I():
    def identity(obj):
        return obj
    return identity

FORMAT = defaultdict(I)
FORMAT.update(
        UInt8=num(int), Int16=num(int),
        UInt32=num(int), UInt64=num(int),
        Int8=num(int), Int32=num(int),
        Int64=num(int),
        Float32=num(float), Float64=num(float),
        String=six.text_type,
        FixedString=six.text_type,
        Date=date, DateTime=datetime
)
