from __future__ import unicode_literals, print_function
import re
import six


class Error(Exception):
    pass


class DatabaseError(Error):
    pass


class InternalError(DatabaseError):
    pass


class ProgrammingError(DatabaseError):
    pass


class OperationalError(DatabaseError):
    @classmethod
    def from_response(cls, response):
        query = response.request.body
        return cls(str('Status {r.status_code}: {r.reason}; '
                   '{r.content}\nQuery:\n{q}').format(
                    r=response, q=query))

    @property
    def code(self):
        res = re.search(r'Code: (?P<code>\d+)', str(self))
        if res is not None:
            return int(res.group('code'))
        else:
            return -1
