# -*- coding: utf-8 -*-
# pylint: disable=too-many-arguments
# pylint: disable=too-many-locals
# pylint: disable=invalid-name
# pylint: disable=too-few-public-methods
from __future__ import unicode_literals

from collections import OrderedDict
import re
import six

from chapi.client import Connection
from chapi.tools import integers
from chapi.errors import InternalError, ProgrammingError


class QResolver(object):
    """Class for resolving queries, behaves like a dict

    instead of keys there are functions with boolean return value
    if item matches some key, then it's value returned
    """
    def __init__(self, *args, **kwargs):
        dic = OrderedDict(*args, **kwargs)

        def castkey(k):
            if not callable(k):
                if not isinstance(k, six.string_types):
                    raise ValueError('Only strings or callables allowed')
                return lambda s: re.search(k, s)
            else:
                return k

        casted_dic = OrderedDict([(castkey(key), val)
                                  for key, val in dic.items()])
        self.dic = casted_dic

    def __getattr__(self, item):
        return getattr(self.dic, item)

    def __getitem__(self, item):
        for key, value in self.items():
            if key(item):
                return value
        raise KeyError('No match found for {}'.format(item))


class FakeConnection(Connection):
    """Connection for performing tests

    :param fakedata: dict with expected responce data for given key(query).

    .. Note:
        You can pass QResolver as fakedata, then
        queries will be resolved in the order you define
    """
    def __init__(self, fakedata=None,
                 host=None, port=None, username=None, password=None,
                 connect_timeout=None, read_timeout=None, json=None,
                 jupyter=True, retries=None, errors=None, raise_on_known=None,
                 strategy=None, power=None):
        # to maintain calls with host, port etc as positionals,
        # but ignore if not specified when making fake connection
        self.fakedata = fakedata or dict()
        host = host or 'fake'
        port = port or 'fake'
        username = username or 'fake'
        password = password or 'fake'
        super(FakeConnection, self).__init__(
                host, port, username, password,
                connect_timeout, read_timeout,
                json, jupyter, retries, errors,
                raise_on_known, strategy, power)

    def request(self, query, _output=True, httpargs=None):
        if self._closed:
            raise InternalError('Connection is closed')
        if re.search(r'[)\s]FORMAT\s', query, re.IGNORECASE):
            raise ProgrammingError('Formatting is not available')
        if _output:
            query += ' FORMAT JSONCompact'
            try:
                content = self.fakedata[query]
            except KeyError:
                content = []
            return self._prepare_output(content)

    @staticmethod
    def _prepare_output(content):
        if content and not isinstance(content[0], dict):
            content = [OrderedDict(zip(integers(), row)) for row in content]
        return content
