import os
from datetime import datetime

# https://sandbox.yandex-team.ru/resource/451408451
# https://a.yandex-team.ru/arc/history/trunk/arcadia/search/wizard/data/wizard/LingBoost/ya.make
DSSM_MODEL = 'lingboost.dssm.model'


def get_queries_embeddings(queries, title_key):
    TMP_QUERIES_FILE = 'queries_for_dssm.txt'
    RESULT_FILE = 'embeddings.txt'
    with open(TMP_QUERIES_FILE, 'w') as f:
        for q in queries:
            f.write('{}\t\n'.format(q[title_key]))
    print(datetime.now(), 'queries written')

    cmd = 'cat {} | ./kernel/dssm_applier/nn_applier/nn_applier apply -m {} --header query,expansion -o query_embedding > {}'.format(TMP_QUERIES_FILE, DSSM_MODEL, RESULT_FILE)  # noqa
    print(cmd)
    os.system(cmd)
    os.system('rm {}'.format(TMP_QUERIES_FILE))

    for emb in open(RESULT_FILE):
        yield [float(x) for x in emb.split(' ') if len(x) > 0]


def main(queries_list, in2, in3, mr_tables, token1=None, token2=None, param1=None, param2=None, html_file=None):
    title_key, embed_key = param1, param2

    print(datetime.now(), 'start, {} queries'.format(len(queries_list)))
    embs = get_queries_embeddings(queries_list, title_key)
    print(datetime.now(), 'embeddings done')

    for q, emb in zip(queries_list, embs):
        q[embed_key] = emb
        yield q