#!/usr/bin/env python
# coding: utf-8

import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import re
import json
import itertools
from collections import defaultdict
from pprint import pprint

from datetime import date, datetime
from chapi import Connection
from sins2_clickhouse.proto import Proto


def format_query(q):
    q = q.replace('+', ' ')
    q = q.capitalize()
    q += '?'
    return q


def main(*args):
    in1, in2, in3, token, any_param, html_file = args

    config = in1[0]

    conn = Connection(read_timeout=1800,
                    host='mtstat01-1.yandex.ru', port=8123,
                    username=config['username'], password=config['password'])

    date_start = datetime.strptime(config['date_start'], '%Y-%m-%d').date()
    date_end = datetime.strptime(config['date_end'], '%Y-%m-%d').date()

    proto = Proto(conn)
    proto.configure(accept=config['accept'])
    if 'reject_hosts' in config:
        proto.configure(reject_hosts=config['reject_hosts'])
    proto.configure(start=date_start)
    proto.configure(end=date_end)

    print datetime.now()
    proto.get()
    print datetime.now()

    queries_list = [(format_query(x.query), x.count) for x in proto.query_count(100000) if x.count > 1]

    return queries_list
