# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from itertools import ifilter, chain



ALEXKUK_TOPIC_SUGGEST = 'feriat.alexkuk_hosts'


def regex_match(regexps=(), field='SearchPhrase', op='OR', prep='', start='AND', default=''):
    if regexps:
        return start + ' (' + (' ' + op + ' ').join("%smatch(%s,'%s')" %
            (prep, field, regex)
            for regex in regexps) + ')'
    else:
        return default


def searches(codes=()):
    codes = chain(codes, [0])
    return 'AND SearchEngineID in (' + ','.join("%d" %
                                                code for code in codes) + ')'


def limit(n=None):
    return 'LIMIT %d' % n if n else ''


def or_(conds=(), start="AND"):
    res = ' OR '.join(ifilter(bool, conds))
    if res:
        return start + " (" + res + u")"
    else:
        return ''


def and_(conds=(), start="AND"):
    res = ' AND '.join(ifilter(bool, conds))
    if res:
        return start + " (" + res + ")"
    else:
        return ''


def replace(string, pattern, replacement):
    """
    >>> replace('toString(EventDate)', '(\\d{4})-(\\d{2})-(\\d{2})', '\\2/\\3/\\1')
    "replaceRegexpAll(toString(EventDate),'(\\d{4})-(\\d{2})-(\\d{2})','\\2/\\3/\\1')"
    """
    return "replaceRegexpAll(" + string + ",'" + pattern + "','" + replacement + "')"


def replacemany(string, patterns_replacements=(), as_=''):
    """
    >>> replacemany('field')
    'field'
    >>> replacemany('field', [('a', 'A'), ('b', 'B')])
    u"replaceRegexpAll(replaceRegexpAll(field,'a','A'),'b','B')"
    >>> replacemany('field', [('a', 'A'), ('b', 'B')], 'myfield')
    u"replaceRegexpAll(replaceRegexpAll(field,'a','A'),'b','B') AS myfield"
    """
    for pattern, replacement in patterns_replacements:
        string = replace(string, pattern, replacement)
    if as_:
        string += ' AS ' + as_
    return string


def union(tables):
    query = ' UNION ALL '.join('SELECT * FROM %s' % table for table in tables)
    return query


def _custom(custom=None):
    return 'AND %s' % custom if custom else ''


def alexkuk_caregory_filter(topics, start='AND', field='URLDomain', deny=False):
    if not topics:
        return ''
    if deny:
        template = '{start} {field} NOT IN ({host_list})'
    else:
        template = '{start} {field} IN ({host_list})'
    content = ', '.join("'%s'" % t for t in topics)
    if not content:
        return ''
    host_list = 'select Host from {table} where Categ IN ({content})'.format(
            table=ALEXKUK_TOPIC_SUGGEST, content=content)
    return template.format(start=start, field=field, host_list=host_list)


def func(op, x='x'):
    template = '{x} -> {op}'
    return template.format(x=x, op=op)


def arrayAll(arg, op, start='AND'):
    template = """{start} arrayAll(
            {func},
            {arg}
            )"""
    if op:
        return template.format(start=start, arg=arg, func=func(op))
    else:
        return ''


def arrayFilter(cond, *seq):
    template = 'arrayFilter({cond}, {arrays})'
    arrays = ', '.join(seq)
    return template.format(cond=cond, arrays=arrays)


def arrayExists(cond, *seq):
    template = 'arrayExists({cond}, {arrays})'
    arrays = ', '.join(seq)
    return template.format(cond=cond, arrays=arrays)


def roundTimeToSec(sec=1, field='EventTime'):
    template = 'toDateTime(intDiv(toUInt32({field}), {round}) * {round})'
    return template.format(field=field, round=sec)


def sql_params(**kwargs):
    """without date!"""
    post_reject = arrayAll(
            arg='Phrases',
            op=regex_match(kwargs['reject'],
                           field='x',
                           op='OR',
                           prep='',
                           start='NOT',
                           default=''),
            start=''
    )
    post_reject_raw = arrayAll(
            arg='RawPhrases',
            op=regex_match(kwargs['pre_reject'],
                           field='x',
                           op='OR',
                           prep='',
                           start='NOT',
                           default=''),
            start=''
    )
    post_reject_hosts = arrayAll(
            arg='Hosts',
            op=regex_match(kwargs['reject_hosts'],
                           field='x',
                           op='OR',
                           prep='',
                           start='NOT',
                           default=''),
            start=''
    )
    post_reject_category = arrayAll(
            arg='Hosts',
            op=alexkuk_caregory_filter(kwargs['reject_category'],
                                       start='',
                                       field='x',
                                       deny=True),
            start=''
    )
    res = dict(
             abstract_phrase=replacemany('SearchPhrase', kwargs['replacements']),
             accept_conditions=or_([
                 regex_match(kwargs['accept'],
                             field='APhrase',
                             op='OR',
                             start=''),
                 regex_match(kwargs['accept_hosts'],
                             field='URLDomain',
                             op='OR',
                             start=''),
                 regex_match(kwargs['pre_accept'],
                             field='SearchPhrase',
                             op='OR',
                             start=''),
                 alexkuk_caregory_filter(kwargs['accept_category'], start='')
             ],
                     start='AND'),
             reject_conditions=or_([
                 regex_match(kwargs['reject'],
                             field='APhrase',
                             op='OR',
                             start=''),
                 regex_match(kwargs['reject_hosts'],
                             field='URLDomain',
                             op='OR',
                             start='')],
                     start="AND NOT"),
             having_post_reject=and_([
                 post_reject,
                 post_reject_hosts,
                 post_reject_raw,
                 post_reject_category
                ],
                start='HAVING'),
             searchids=searches(kwargs['searchids']),
             sample=kwargs['sample'],
             delta=kwargs['delta'],
             custom=_custom(kwargs['custom']))
    return res


def ifelse(cond, true, false):
    template = 'if({cond},{true},{false})'
    return template.format(cond=cond, true=true, false=false)
