# -*- coding: utf-8 -*-

import telegram
from telegram import InlineKeyboardButton, InlineKeyboardMarkup
from telegram.ext import CommandHandler
from telegram.ext import MessageHandler, Filters
from telegram.ext import CallbackQueryHandler
from telegram.ext import Updater
import os
import logging
import random
import atom_duty_startrek

PATH = '/home/zaringleb/atom_bot/'
user_whitelist = ['zaringleb', 'rogdenis', 'Goshman', 'pecheny', 'norberrt']
dir_path = os.path.dirname(os.path.realpath(__file__))


logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)
fh = logging.FileHandler(PATH + 'atom_bot.log')
fh.setFormatter(logging.Formatter('%(asctime)s %(levelname)s:%(message)s'))
logger.addHandler(fh)


def make_ticket(message):
    summary = message.split(".", 1)[0]
    description = message.split(".", 1)[-1] if "." in message else ""
    answer = atom_duty_startrek.create_ticket(summary, description)
    url = atom_duty_startrek.st_url_from_ticket(answer['key'])
    return url


def error(bot, update, error):
    logger.warn('Update "%s" caused error "%s"' % (update, error))


def get_person_on_duty():
    with open(PATH + 'person_on_duty.txt') as f:
        return f.read().strip()


def put_person_on_duty(username):
    with open(PATH + 'person_on_duty.txt', 'w') as f:
        f.write(username)


def get_commands():
    with open(PATH + 'commands.txt') as f:
        return f.read()


def get_hello():
    with open(PATH + 'hello.txt') as f:
        return "{}\n{}".format(f.read(), get_commands())


def get_chart(name):
    f = open(PATH + "{}.png".format(name), 'rb')
    return f


def get_rand_pic(pics_dir):
    pics = os.listdir(PATH + pics_dir)
    f = open(PATH + pics_dir + "/{}".format(random.choice(pics)), 'rb')
    return f


def get_bot_token():
    with open('/home/zaringleb/.jack_token') as f:
        return f.readline().strip()


def start(bot, update):
    logger.info('FROM: {} TEXT: {} CHART_ID: {}'.format(update.message.from_user.username, update.message.text.encode('UTF-8'), update.message.chat_id))
    bot.sendMessage(chat_id=update.message.chat_id, text=get_hello())


def menu(bot, update):
    keyboard = [[InlineKeyboardButton("duty", callback_data='duty'),
                 InlineKeyboardButton("charts", callback_data='charts'),
                 InlineKeyboardButton("tickets", callback_data='tickets'),
                 InlineKeyboardButton("duty page", url='https://wiki.yandex-team.ru/JandeksPoisk/KachestvoPoiska/research/Personalization/Atom/AnalystDuty/')]]

    reply_markup = InlineKeyboardMarkup(keyboard, resize_keyboard=True)
    update.message.reply_text('menu: ', reply_markup=reply_markup)


def charts(bot, update):
    keyboard = [[InlineKeyboardButton("main", callback_data='charts_main'),
                 InlineKeyboardButton("idm", callback_data='charts_idm')],
                [InlineKeyboardButton("browser_kernel", callback_data='charts_browser_kernel'),
                 InlineKeyboardButton("allextensions_kernel", callback_data='charts_allextensions_kernel'),
                 InlineKeyboardButton("mobile_kernel", callback_data='charts_mobile_kernel')],
                [InlineKeyboardButton("browser", callback_data='charts_browser'),
                 InlineKeyboardButton("allextensions", callback_data='charts_allextensions'),
                 InlineKeyboardButton("mobile", callback_data='charts_mobile')]]

    reply_markup = InlineKeyboardMarkup(keyboard, resize_keyboard=True)
    bot.send_message(chat_id=update.callback_query.message.chat_id, text="choose chart: ", reply_markup=reply_markup)


def button(bot, update):
    query = update.callback_query
    if query.data == 'duty':
        bot.send_message(chat_id=query.message.chat_id, text=get_person_on_duty())
    elif query.data == 'charts':
        charts(bot, update)
    elif query.data.startswith('charts_'):
        if query.data == 'charts_main':
            for one in ["browser_kernel", "allextensions_kernel", "mobile_kernel"]:
                pic = get_chart(one)
                bot.sendPhoto(chat_id=query.message.chat_id, photo=pic)
                pic.close()
        else:
            pic = get_chart(query.data.split("_", 1)[-1])
            bot.sendPhoto(chat_id=query.message.chat_id, photo=pic)
            pic.close()
    elif query.data == 'tickets':
        tickets = atom_duty_startrek.get_tickets()
        message = atom_duty_startrek.print_tickets(tickets) or 'no open tickets'
        bot.send_message(chat_id=query.message.chat_id, text=message)


def commands(bot, update):
    logger.info('FROM: {} TEXT: {} CHART_ID: {}'.format(update.message.from_user.username, update.message.text.encode('UTF-8'), update.message.chat_id))
    bot.sendMessage(chat_id=update.message.chat_id, text=get_commands())


def person_on_duty(bot, update, args):
    logger.info('FROM: {} TEXT: {} CHART_ID: {}'.format(update.message.from_user.username, update.message.text.encode('UTF-8'), update.message.chat_id))
    user = update.message.from_user
    if args:
        if args[0] == 'skip':
            if user.username in user_whitelist:
                os.system("python {}/changing_guard.py".format(dir_path))
            else:
                bot.sendMessage(chat_id=update.message.chat_id, text='permission denied')
        else:
            bot.sendMessage(chat_id=update.message.chat_id, text='do you meant "skip"?')
    bot.sendMessage(chat_id=update.message.chat_id, text='person on duty today {}'.format(get_person_on_duty()))


def get_duty_text():
    with open(PATH + 'duty.txt') as f:
        return f.read()


def person_on_duty_new(bot, update, args):
    bot.sendMessage(chat_id=update.message.chat_id, text=get_duty_text())


def chart(bot, update, args):
    logger.info('FROM: {} TEXT: {} CHART_ID: {}'.format(update.message.from_user.username, update.message.text.encode('UTF-8'), update.message.chat_id))
    user = update.message.from_user
    if args:
        if args[0] == 'main':
            for one in ["browser_kernel", "allextensions_kernel", "mobile_kernel"]:
                pic = get_chart(one)
                bot.sendPhoto(chat_id=update.message.chat_id, photo=pic)
                pic.close()
        else:
            pic = get_chart(args[0])
            bot.sendPhoto(chat_id=update.message.chat_id, photo=pic)
            pic.close()
    else:
        text='Please specify argument,\navailable args: "browser", "allextensions", "mobile" or "main" to send all\nexample: /chart browser'
        bot.sendMessage(chat_id=update.message.chat_id, text=text)


def dontclickthis(bot, update):
    user = update.message.from_user
    pic = get_chart('pain')
    bot.sendPhoto(chat_id=update.message.chat_id, photo=pic)


def talk(bot, update):
    logger.info('FROM: {} TEXT: {} CHART_ID: {}'.format(update.message.from_user.username, update.message.text.encode('UTF-8'), update.message.chat_id))

    message = update.message.text
    if 'duty_st' in message:
        url = make_ticket(message)
        bot.sendMessage(chat_id=update.message.chat_id, text=url)


def unknown(bot, update):
    logger.info('FROM: {} TEXT: {} CHART_ID: {}'.format(update.message.from_user.username, update.message.text.encode('UTF-8'), update.message.chat_id))
    bot.sendMessage(chat_id=update.message.chat_id, text="Sorry, I didn't understand that command, try /help")


def main():
    updater = Updater(token=get_bot_token())
    dispatcher = updater.dispatcher

    start_handler = CommandHandler('start', start)
    dispatcher.add_handler(start_handler)

    menu_handler = CommandHandler('menu', menu)
    dispatcher.add_handler(menu_handler)

    help_handler = CommandHandler('help', commands)
    dispatcher.add_handler(help_handler)

    get_person_on_duty_handler = CommandHandler('duty', person_on_duty_new, pass_args=True)
    dispatcher.add_handler(get_person_on_duty_handler)

    chart_handler = CommandHandler('chart', chart, pass_args=True)
    dispatcher.add_handler(chart_handler)

    dontclickthis_handler = CommandHandler('dontclickthis', dontclickthis)
    dispatcher.add_handler(dontclickthis_handler)

    unknown_handler = MessageHandler(Filters.command, unknown)
    dispatcher.add_handler(unknown_handler)

    talk_handler = MessageHandler(Filters.text, talk)
    dispatcher.add_handler(talk_handler)

    dispatcher.add_handler(CallbackQueryHandler(button))

    dispatcher.add_error_handler(error)

    updater.start_polling()
    updater.idle()


if __name__ == '__main__':
    main()
