# -*- coding: utf-8 -*-

import requests
import json


def get_oauth():
    with open('/home/zaringleb/.oauth') as f:
        return f.read().rstrip()


def create_ticket(summary, description):
    oauth = get_oauth()
    headers = {"Authorization": "OAuth {}".format(oauth)}
    data = {"queue": "PERSONAL", "summary": summary, 'description': description, 'tags': ['atom_duty']}
    r = requests.post("https://st-api.yandex-team.ru/v2/issues", headers=headers, data=json.dumps(data), verify=False)
    q = json.loads(r.content)
    return q


def get_tickets(queue='PERSONAL'):
    oauth = get_oauth()
    headers = {"Authorization": "OAuth {}".format(oauth)}
    data = {
            "filter": {"queue": queue, 'tags': 'atom_duty', 'resolution': 'empty()'}
            }
    r = requests.post("https://st-api.yandex-team.ru/v2/issues/_search?perPage=15", headers=headers, data=json.dumps(data), verify=False)
    q = json.loads(r.content)
    return q


def print_tickets(tickets):
    return "\n".join(ticket['summary'] + "   " + st_url_from_ticket(ticket['key']) for ticket in tickets)


def st_url_from_ticket(ticket):
    return "https://st.yandex-team.ru/{}".format(ticket)

