# -*- coding: utf-8 -*-

import telegram
from telegram.ext import CommandHandler
from telegram.ext import MessageHandler, Filters
from telegram.ext import Updater
import os
import logging
import random


PATH = '/home/zaringleb/atom_bot/'
user_whitelist = ['zaringleb', 'rogdenis', 'Goshman', 'pecheny', 'norberrt']


def get_chat_id(person):
    person_chat = {'zaringleb': "167654071",
                   'rogdenis': '53805328',
                   'Goshman': '55693900',
                   'pecheny': '663024',
                   'norberrt': '232638485'}
    return person_chat[person]


def get_person_on_duty():
    with open(PATH + 'person_on_duty.txt') as f:
        return f.read().strip()


def get_chart(name):
    f = open(PATH + "{}.png".format(name), 'rb')
    return f


def get_bot_token():
    with open('/home/zaringleb/.jack_token') as f:
        return f.readline().strip()


def send_charts_to_chat(chat_id, bot):
    message = "Hi!\nYou are on duty today. Please, check the following charts."
    bot.sendMessage(chat_id=chat_id, text=message)
    for one in ["browser_kernel", "allextensions_kernel", "mobile_kernel"]:
        pic = get_chart(one)
        bot.sendPhoto(chat_id=chat_id, photo=pic)
        pic.close()


def main():
    bot = telegram.Bot(token=get_bot_token())
    person_on_duty = get_person_on_duty()
    chart_id = get_chat_id(person_on_duty)
    send_charts_to_chat(chart_id, bot)


if __name__ == '__main__':
    main()
