# -*- coding: utf-8 -*-

import requests
import shutil
from urllib import urlencode


def get_stat_login():
    with open('/home/zaringleb/.stat_login') as f:
        return f.readline().strip()


def download_stat_chart(name, path):
    url = "https://charts.yandex-team.ru/api/scr/v1/screenshots"
    params = {
            'path': '{}&_no_controls=1&_embedded=1'.format(path),
            'width': 1600,
            'height': 720,
            }
    stat_login = get_stat_login()
    payload = urlencode(params)
    headers = {
            'statrobotauth': "robot_zaringleb:{}".format(stat_login),
            'content-type': "application/x-www-form-urlencoded"
            }
    response = requests.request("POST", url, data=payload, headers=headers, stream=True, verify=False)
    with open('{}.png'.format(name), 'wb') as out_file:
        shutil.copyfileobj(response.raw, out_file)


def main():
    charts = {'allextensions' : '/ChartPreview/ChartEditor?name=riddle/allextensions',
            'browser' : '/ChartPreview/ChartEditor?name=ensuetina_abt_monitoring%2Frazladki_atom&ncrnd=3339',
            'mobile' : '/ChartPreview/ChartEditor?name=riddle/mobile'}

    for name, path in charts.items():
        download_stat_chart(name, path)

if __name__ == '__main__':
    main()
