# -*- coding: utf-8 -*-

import datetime
import os
import numpy as np
import json
import requests
import logging
import matplotlib
import matplotlib.pyplot as plt
import seaborn as sns

matplotlib.use('Agg')
sns.set_style("whitegrid")


def K(r):
    return np.exp(-2*(r**2))


def kernel(x, h, ar):
    return (ar[:, 1]*(K((ar[:, 0]-x)/h))).sum()/(K((ar[:, 0]-x)/h)).sum()


razladki_url = 'http://razladki.yandex-team.ru/api/{}/plot_data'
logging.basicConfig(format='%(asctime)s %(levelname)s:%(message)s', filename='kernel_chart.log', level=logging.INFO)


with open('charts_config.json') as f:
    config = json.loads(f.read())


def main():
    t_now = datetime.datetime.now()
    ts_to = t_now.strftime("%Y-%m-%d+%H:%M:%S")
    ts_from = (t_now - datetime.timedelta(days=config['days'])).strftime("%Y-%m-%d+%H:%M:%S")

    for chart in config['charts']:
        logging.info(chart)
        # print(chart)
        lines = config['charts'][chart]['lines']
        coefs = config['charts'][chart].get('coefs', dict())

        request_param = {'smooth': 0, 'param': lines}
        r = requests.get(razladki_url.format(config['charts'][chart]['project']) + "?ts_from={}&ts_to={}".format(ts_from, ts_to), params=request_param)
        obj = json.loads(r.text)

        h = (config['charts'][chart].get('h') or config['h'])*60  # to minutes

        plot = config['charts'][chart].get('plot', {})
        fig = plt.figure(figsize=(15, 5))
        if plot.get('ymax'):
            plt.ylim(ymax=plot['ymax'])
        plt.title(chart, fontsize=17)
        lines = []
        for key in obj:
            if obj[key]:
                ar = np.array(obj[key])
                # plt.plot([datetime.datetime.fromtimestamp(one) for one in ar[:,0]], ar[:,1], linewidth=1)
                line, = plt.plot([datetime.datetime.fromtimestamp(one) for one in ar[:, 0]], [kernel(one, h, ar)*coefs.get(key, 1) for one in ar[:, 0]], linewidth=2, label=key)
                lines.append(line)
        plt.legend(fontsize=12, markerscale=1, loc=1, bbox_to_anchor=(0.8, -0.05))
        fig.savefig('{}.png'.format(chart), bbox_inches='tight')

if __name__ == "__main__":
    main()

