import os
import datetime
import argparse

import atom_bot_lib
error_pattern = "CRITICAL"

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--send_to', action='store')
    parser.add_argument('--log_path', action='store')
    parser.add_argument('--max_errors', action='store')
    args = parser.parse_args()

    previous_hour = datetime.datetime.now() - datetime.timedelta(hours = 1)
    previous_hour_pattern = previous_hour.strftime('%Y-%m-%d_%H')

    error_counter = 0
    for filename in os.listdir(args.log_path):
        if filename.startswith(previous_hour_pattern):
            with open(os.path.join(args.log_path, filename)) as log_file:
                if error_pattern in log_file.read():
                    error_counter += 1

    if error_counter > int(args.max_errors):
        message = "{}: {} = {}".format(os.path.basename(args.log_path), previous_hour_pattern, error_counter)
        atom_bot_lib.send_message(message, args.send_to)

if __name__ == "__main__":
    main()

