# -*- coding: utf-8 -*-

import requests
import json

PATH = "//home/zaringleb/panels/"

def get_past_tickets():
    with open(PATH + 'tickets.txt') as f:
        tickets = f.readlines()
        tickets = [ticket.strip() for ticket in tickets]
    return tickets

def get_oauth():
    with open('/home/zaringleb/.oauth') as f:
        return f.read().rstrip()

def put_past_tickets(ticket):
    with open(PATH + 'tickets.txt', 'a') as f:
        f.write(ticket + "\n")

def check_updates(ticket):
    oauth = get_oauth()
    headers = {"Authorization": "OAuth {}".format(oauth)}
    r = requests.get("https://st-api.yandex-team.ru/v2/issues/{ticket}/comments".format(ticket=ticket), headers=headers)
    updates = []
    for comment in json.loads(r.content):
        if comment['createdBy']['id'] == 'robot-eksperimentus':
            if "**!!(green)satisfied!!** request to make a change to testids" in comment['text']:
                updates.append('{} {}'.format(ticket, comment['createdAt']))
    return updates

def manage_updates(updates):
    with open(PATH + 'tickets_updates.txt') as f:
        tickets_updates = f.readlines()
        tickets_updates = [one.strip() for one in tickets_updates]
    with open(PATH + 'tickets_updates.txt', 'a') as f:
        for update in updates:
            if update in tickets_updates:
                pass
            else:
                f.write(update  + "\n")
                del_past_ticket(update.split(' ')[0])

def del_past_ticket(ticket):
    with open(PATH + 'tickets.txt') as f:
        tickets = f.readlines()
    tickets = [ticket.strip() for ticket in tickets]
    with open(PATH + 'tickets.txt', 'w') as f:
        for one in tickets:
            if one != ticket:
                f.write(one + "\n")

def main():
    updates = []
    for ticket in get_past_tickets():
        updates.extend(check_updates(ticket))
    manage_updates(updates)


if __name__ == "__main__":
    main()
