#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
from prepare_atom_experiment import get_creatives, post_creatives


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('srclist')
    parser.add_argument('host')
    args = parser.parse_args()

    creatives = get_creatives(args.srclist)

    for creative in creatives:
        creative['internal-url'] = '{}/{}'.format(
            args.host,
            creative['internal-url'].split('/')[1]
        )

    post_creatives(args.srclist, creatives, reqtype='put')

if __name__ == "__main__":
    main()
