#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
from putils import utf8ify, deutf8ify, parseparams
from mrdef import defaults
from mapreducelib import MapReduce, Record
import base64
import datetime
import json


class AtomfrontUidGrep(object):

    def __init__(self, uid):
        self.uid = uid

    def __call__(self, rec):
        rec = deutf8ify(rec)
        params = parseparams(rec.value)
        uid = params['text'].split('/')[0]
        b64 = params['text'].split('\\t')[-1]
        ts = datetime.datetime.fromtimestamp(
            int(params['unixtime'])
        ).strftime('%Y-%m-%d %H:%M:%S')
        decoded = json.loads(base64.b64decode(b64).decode('utf8'))
        if self.uid in set(decoded.get('userId', {}).values()):
            yield utf8ify(Record(
                self.uid,
                ts,
                json.dumps(decoded, ensure_ascii=False)
            ))


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('uid')
    parser.add_argument('date')
    args = parser.parse_args()

    defaults()

    atomfront_uid_grep = AtomfrontUidGrep(args.uid.decode('utf8'))

    MapReduce.runMap(atomfront_uid_grep,
                     srcTable='atomfront_answer_log/{}'.format(args.date),
                     dstTable='tmp/pers/{}_grepped_{}'.format(
                         args.uid, args.date
                     ))


if __name__ == "__main__":
    main()
