#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import base64
import datetime
import json
import yt.wrapper as yt
from pytils import yt_config_set_defaults


class AtomfrontUidGrep(object):

    def __init__(self, uid):
        self.uid = uid

    def __call__(self, rec):
        b64 = rec['text'].split('\\t')[-1]
        ts = datetime.datetime.fromtimestamp(
            int(rec['unixtime'])
        ).strftime('%Y-%m-%d %H:%M:%S')
        try:
            decoded = json.loads(base64.b64decode(b64).decode('utf8'))
        except:
            return
        if self.uid in set(decoded.get('userId', {}).values()):
            yield {
                'uid': self.uid,
                'timestamp': ts,
                'atom_data': json.dumps(decoded, ensure_ascii=False).decode(
                    'utf8'
                )
            }


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('srcdate')
    parser.add_argument('uid')
    args = parser.parse_args()

    yt_config_set_defaults(yt, None)

    atomfront_uid_grep = AtomfrontUidGrep(args.uid.decode('utf8'))

    dest_table = '//tmp/personalization/atomlog_grep/{}_{}'.format(
        args.uid, args.srcdate
    )

    yt.run_map(
        atomfront_uid_grep,
        source_table=yt.TablePath(
            '//statbox/atomfront-answer-log/{}'.format(args.srcdate),
            columns=['text', 'unixtime']
        ),
        destination_table=dest_table,
        format=yt.YsonFormat()
    )
    print("https://yt.yandex-team.ru/hahn/#page=navigation&path={}"
          .format(dest_table))


if __name__ == "__main__":
    main()
