# -*- coding: utf-8 -*-

import requests
import json
import collections
import urllib2
import io
import tarfile
import os
import commands
import logging

PATH = "//home/zaringleb/panels/"

def parse_relev(relev):
    if "_stored-candidate-list=" in relev:
        sub_client = relev.split("=")[0][len("atom_"):-len("_stored-candidate-list")]
        return sub_client

def parse_report(context):
    logging.debug('Handler Report')
    for client in context['MAIN']['source']:
        relev = context['MAIN']['source'][client]['relev'][0].split(";")[0]
        sub_client = parse_relev(relev)
        return dict(client=client.lower(), sub_client=sub_client)

def parse_gateway(context):
    relev = context['GATEWAY']['atom.params.relev'][0].split(";")[0]
    sub_client = parse_relev(relev)
    return dict(sub_client=sub_client)

def parse_atom(context):
    relev = context['ATOM']['atom.params.relev'][0].split(";")[0]
    sub_client = parse_relev(relev)
    return dict(sub_client=sub_client)

def parse_testid(exp):
    author= exp['author']
    ticket = exp['ticket']
    testid = exp['testid']
    params = json.loads(exp['params'])[0]
    if params['HANDLER'] == 'REPORT':
        exp_dict = parse_report(params['CONTEXT'])
        exp_dict['client'] = 'distr_serp' if exp_dict['client'].lower() == 'atom_serp' else exp_dict['client']
    elif params['HANDLER'] == 'GATEWAY':
        client = params['CONDITION'][len("SESSION_atom_client == '"): -1]
        exp_dict = parse_gateway(params['CONTEXT'])
        exp_dict['client'] = client
    elif params['HANDLER'] == 'ATOM':
        client = params['CONDITION'][len("SESSION_atom_client == '"): -1]
        exp_dict = parse_atom(params['CONTEXT'])
        exp_dict['client'] = client
    return exp_dict

def get_clients_from_conf():
    url = 'http://avatar.yandex.ru:8090/viewconfig'
    req = requests.get(url)
    conf = req.json()
    clients_sub_clients = collections.defaultdict(list)
    for client in conf['clients']:
        if 'sub' in conf['clients'][client]:
            for sub_client in conf['clients'][client]['sub']:
                clients_sub_clients[client.lower()].append(sub_client.lower())
        else:
            clients_sub_clients[client.lower()].append("")
    return clients_sub_clients

def check_clients(parsed, clients_from_conf):
    if parsed['sub_client'] in clients_from_conf[parsed['client']]:
        return True
    return False

def get_past_tickets():
    with open(PATH + 'tickets.txt') as f:
        tickets = f.readlines()
        tickets = [ticket.strip() for ticket in tickets]
    return tickets

def put_past_tickets(ticket):
    with open(PATH + 'tickets.txt', 'a') as f:
        tickets = f.write(ticket + "\n")

def get_testid_info(testid):
    url = 'http://ab.yandex-team.ru/api/testid?type=ABT&form=full&id='
    req = requests.get(url + testid)
    conf = [one for one in req.json() if 'atom_' in str(one)]
    if conf:
        conf = conf[0]
        out = parse_testid(conf)
        return out

def get_tasks(aspects=['atom', 'promolib']):
    url = 'http://ab.yandex-team.ru/api/task?form=full&aspect='
    tasks = []
    for aspect in aspects:
        req = requests.get(url + aspect)
        #print(aspect)
        tasks.extend([one for one in req.json() if one['state'] in ['RUNNING', 'IN_CONFIG']])
    q = [{prop : one[prop] for prop in ['ticket', 'testids', 'authorities', 'author']} for one in tasks]
    return q

def plot_golovan(task):
    os.chdir("/home/zaringleb/rerank_service/tools/scripts/yasm")

    command = 'python //home/zaringleb/rerank_service/tools/scripts/yasm/gen_atom_panels.py' \
                ' -u zaringleb --cc {editors} -c {client}-{sub_client} -e "{ticket} {testids}"'.format(
                editors = ",".join(set(task['authorities'].split() + [task['author']] + ['zaringleb'])),
                client = task['client'],
                sub_client = task['sub_client'],
                ticket = task['ticket'],
                testids = ",".join(map(str, task['testids'])))
    logging.debug("command:{}".format(command))
    status, output = commands.getstatusoutput(command)
    tmp = output.split("\n", 2)[-1][len("INFO:root:"):]
    return json.loads(output.split("\n", 2)[-1][len("INFO:root:"):])['result']['_id']

def get_oauth():
    with open('/home/zaringleb/.oauth') as f:
        return f.read().rstrip()

def post_in_ticket(plot_id, key):
    golovan_url = "https://yasm.yandex-team.ru/panel/" + plot_id
    oauth = get_oauth()
    headers = {"Authorization": "OAuth {}".format(oauth), "Content-Type": "application/json; charset: UTF-8"}
    ticket_data = { "text": '(({} авто ссылка на голован))'.format(golovan_url), "summonees" : ["zaringleb"]}
    ticket = key
    r = requests.post("https://st-api.yandex-team.ru/v2/issues/{ticket}/comments".format(ticket=ticket), headers=headers, data=json.dumps(ticket_data))

def main():
    logging.basicConfig(format='%(asctime)s %(levelname)s:%(message)s', filename='mylog.log',level=logging.INFO)
    logging.info('Start')
    clients_from_conf = get_clients_from_conf()
    logging.debug('len(atom_conf):{}'.format(len(clients_from_conf)))
    tasks = get_tasks()
    past_tickets = get_past_tickets()
    for task in tasks:
        if task['ticket'] not in past_tickets:
            logging.info('ticket:{}'.format(task['ticket']))
            logging.debug('task:{}'.format(task))
            client_sub_client = {}
            is_ok = True
            for testid in task['testids']:
                logging.debug('testid:{}'.format(testid))
                testid_info = get_testid_info(str(testid))
                if testid_info:
                    if check_clients(testid_info, clients_from_conf):
                        if client_sub_client:
                            if client_sub_client != testid_info:
                                is_ok = False
                                logging.warning('different client/sub_client, testid={}'.format(testid))
                        else:
                            client_sub_client = testid_info
                    else:
                        is_ok = False
                        logging.warning('wrong client/sub_client, testid={}'.format(testid))
                else:
                    is_ok = False
                    logging.warning('no testid_info, testid={}'.format(testid))
            if is_ok:
                #if task['author'] == "zaringleb":
                task.update(client_sub_client)
                plot_id = plot_golovan(task)
                post_in_ticket(plot_id, task['ticket'])
            put_past_tickets(task['ticket'])


if __name__ == "__main__":
    main()
