#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

from __future__ import division

import argparse
import codecs
import datetime
import json
import requests
import subprocess
import sys
import os
import logging

from places.daas_stripe import Daas_stripe
from places.ext_popup import Ext_popup
from places.images_popup import Images_popup
from places.images_wizard import Images_wizard
from places.mobilefooter import Mobilefooter
from places.place import Place
from places.portal_popup import Portal_popup
from places.promofooter import Promofooter
from places.promoliba import Promoliba
from places.smart_banner import Smart_banner
from places.softlink import Softlink
from places.stripe import Stripe
from places.teaser import Teaser
from places.touch_banner import Touch_banner
from places.touch_teaser import Touch_teaser
from places.vb_popup import Vb_popup
from places.vb_stripe import Vb_stripe
from places.wizard import Wizard
from places.videowizard import VideoWizard


class Lock(object):
    def __init__(self, path, logger, filename='lock.txt'):
        self.lockfile = os.path.join(path, filename)
        self.logger = logger

    def check_lock(self):
        try:
            with codecs.open(self.lockfile, 'r', 'utf8') as f:
                contents = f.read().rstrip()
        except IOError:
            contents = 'free'

        is_running = "banana-fetch" in subprocess.Popen(['ps', 'aux'], stdout=subprocess.PIPE).communicate()[0]

        if contents != 'free' and is_running:
            self.logger.critical("previous not finished yet")
            sys.exit(0)

        elif contents != 'free' and not is_running:
            self.logger.warning("lock is locked: {}".format(contents))

        elif contents == 'free' and is_running:
            self.logger.warning("previous is running")

        else:
            self.logger.debug("lock is free")

        with codecs.open(self.lockfile, 'w', 'utf8') as f:
            f.write('locked at {}'.format(datetime.datetime.now()))


    def free_lock(self):
        with codecs.open(self.lockfile, 'w', 'utf8') as f:
            f.write('free')


def deploy_candidates(message):
    adminka_api = 'http://atom-admin.n.yandex-team.ru/atom/api/v1/deploy/'
    with open('vault/.atom_admin_token', 'r') as f:
        token = f.readline().strip()
    r = requests.post(
        adminka_api,
        headers={'Authorization': 'Token {}'.format(token)},
        data={'message': message}
    )


def make_logger(_file, debug=False):
    directory = os.path.dirname(_file)
    basename = os.path.splitext(os.path.basename(_file))[0]
    logger = logging.getLogger(basename)
    logger.setLevel(logging.DEBUG)
    if not os.path.isdir('{}/logs'.format(directory)):
        os.mkdir('{}/logs'.format(directory))
    log_format = logging.Formatter('%(asctime)s %(levelname)s: %(message)s')
    fh = logging.FileHandler('{}/logs/{}_{}.log'.format(
        directory, basename, datetime.datetime.now().strftime('%Y-%m-%d_%H-%M-%S')))
    fh.setFormatter(log_format)
    fh.setLevel(logging.INFO)
    logger.addHandler(fh)
    if debug:
        ch = logging.StreamHandler()
        ch.setFormatter(log_format)
        ch.setLevel(logging.DEBUG)
        logger.addHandler(ch)
    return logger


def get_classname(classname):
    if ':' in classname:
        # classname:exp
        class_name, exp = classname.split(':')
        return class_name, '_' + exp
    # classname
    return classname, ''


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("-debug", action='store_true')
    parser.add_argument("-classname", help="class", type=str)
    parser.add_argument(
        "-placeid", help="placeId in banana", nargs='+', type=str)
    parser.add_argument("-collection", help="collection", type=str)
    parser.add_argument("-host", help="host", type=str)
    parser.add_argument("-prefix", help="bannerid prefix", type=str)
    parser.add_argument("-zerogroup_default", help="number of new", type=int)
    parser.add_argument('-excluded_orders', '--excludeorder',
                                            help="excluding orders", nargs='+', type=int)
    parser.add_argument('-included_orders', '--includeorder',
                                            help="including orders", nargs='+', type=int)
    parser.add_argument('-downloaddata', help="download data", type=str)
    parser.add_argument('-nofiltering', help="dont filter data", type=str)
    parser.add_argument('-upload', help="upload to switch", type=str)
    parser.add_argument('-clone_browser', help="clone banners for browser", type=str)
    parser.add_argument('-verbose', help="for verbose mode", type=str)
    parser.add_argument('-smartselect', help="for verbose mode", type=str)
    parser.add_argument('-clone_country', help="clone RU for country", type=str)

    _abs_file = os.path.abspath(__file__)
    args = parser.parse_args()
    logger = make_logger(_abs_file, debug=args.debug)
    logger.info('Started')
    config = json.load(open(os.path.join(os.path.dirname(_abs_file), "import_config.json")))
    lock = Lock(os.path.dirname(_abs_file), logger)

    if args.classname is not None:
        real_classname, exp = get_classname(args.classname)
        params = config[args.classname]
        params['logger'] = logger
        params['lock'] = lock
        params['collection'] += exp
        for param, paramvalue in vars(args).iteritems():
            if paramvalue is not None:
                params[param] = paramvalue
            params['classname'] = real_classname
        params["do"] = True
        globals()[real_classname](params)
    else:
        for classname, params in config.items():
            real_classname, exp = get_classname(classname)
            params['classname'] = real_classname
            params['collection'] += exp
            params['logger'] = logger
            params['lock'] = lock
            try:
                globals()[real_classname](params)
                if params["upload"]:
                    deploy_candidates(message='(robot) banana import collection {}'.format(
                        params['collection']))
            except Exception, e:
                logger.error('Failed {}. Error: {}'.format(classname, e))


if __name__ == '__main__':
    main()
