# -*- coding: utf-8 -*-

import subprocess
import atom_bot_lib

PATH = "/home/zaringleb/"
FML_PATH = "/home/zaringleb/pers/rerank_service/fml/"

def get_fml_list():
    with open(PATH + "PROD_EXP_FML.txt") as f:
        fml_dict = [line.strip().split("\\t") for line in f]
    return fml_dict

def parse_mx_ops_props(data):
    result = dict()
    props = False
    for line in data.split('\n'):
        if 'Model props:' in line:
            props = True
            continue
        if not props or ':' not in line:
            continue
        left, right = line.split(':', 1)
        result[left.strip()] = right.strip()
    return result

def get_mx_info(mx_ops, fml_path):
    cmd = [mx_ops, 'info', fml_path]
    return parse_mx_ops_props(subprocess.check_output(cmd))

def set_mx_property(mx_ops, fml_path, key, value):
    cmd = [mx_ops, 'setprop', fml_path, key, value]
    subprocess.call(cmd)

def procces_pair(prod_fml, exp_fml):
    prod_info = get_mx_info('/home/zaringleb/mx_ops', FML_PATH + prod_fml + ".info")
    exp_info = get_mx_info('/home/zaringleb/mx_ops', FML_PATH + exp_fml + ".info")
    prod_sp = prod_info.get('show-percentage', '')
    exp_sp = exp_info.get('show-percentage', '')
    if prod_sp != exp_sp:
        set_mx_property('/home/zaringleb/mx_ops', FML_PATH + exp_fml + ".info", 'show-percentage', prod_sp)
        message = "Update show-percentage in {} to {}, from prod ({}), previes was {}.\n" \
        "It would be nice if you make commit: svn ci -m 'update sp in {} to {}'\n" \
        "and run deploy: https://sandbox.yandex-team.ru/tasks/?order=-updated&type=BUILD_PERS_RERANK_SERVICE_FMLS&page=1&pageCapacity=20&forPage=tasks" \
        .format(exp_fml, prod_sp, prod_fml, exp_sp, exp_fml, prod_sp)

        atom_bot_lib.send_message(message, 'zaringleb')

def main():
    for one in get_fml_list():
        procces_pair(one[1], one[2])

if __name__ == "__main__":
    main()
