#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import re
from import_banana import check_filter
from prepare_atom_experiment import (
    get_creatives, post_creatives, get_unique_bannerid
)
import pdb


prod_lists = {
    "distr_wizard",
    "distr_wizard_sms",
    "banana/images_popup",
    "banana/images_wizard",
    "banana/extensions_popup",
    "banana/portal_popup",
    "banana/daas_popup",
    "banana/daas_stripe",
    "banana/1127_filtered",
    "banana/extensions_stripe",
    "vb_popup",
    "vb_stripe"
}

allowed_products = {'browser', 'set', 'home', 'sethome', 'vb', 'collections'}

prod = {x: True for x in prod_lists}


def fix_bad_products(filter_):
    for x in re.finditer(r'#products,not_match,%(.+?)%', filter_):
        filter_ = filter_.replace(
            x.group(0), r'#products,not_match,{}'.format(x.group(1))
        )
    return filter_


def main():
    print('getting all_keys')
    all_keys = get_creatives('all_keys')
    collections = {}
    new_all_keys = []
    bannerids = set()
    for key in all_keys:
        if isinstance(key, basestring):
            print('getting {}'.format(key))
            cr = get_creatives(key)
            if cr:
                collections[key] = cr
                new_all_keys.append(key)
            if key not in prod_lists:
                prod[key] = False
        else:
            k = next(iter(key))
            print('getting {}'.format(k))
            cr = get_creatives(k)
            if cr:
                collections[k] = cr
                new_all_keys.append(key)
            if (set(key[k]) & prod_lists):
                prod[k] = True
            else:
                prod[k] = False

    for key in sorted(collections)[::-1]:
        for creative in collections[key]:
            if (creative['internal-url'].split(
                '/'
            )[-1] not in bannerids):
                bannerids.add(creative['internal-url'].split('/')[-1])
            else:
                print('modifying bannerid {}'.format(
                    creative['internal-url'])
                )
                u = get_unique_bannerid(bannerids)
                if '/' in creative['internal-url']:
                    creative['internal-url'] = (
                        (creative['internal-url'].split('/')[0] +
                            '/' + u)
                    )
                else:
                    creative['internal-url'] = u
                bannerids.add(u)

    print('posting all_keys')
    post_creatives('all_keys', new_all_keys, reqtype='put')

    print('prod lists are: {}'.format(', '.join(sorted(
        [x for x in prod if prod[x]]
    ))))

    for key in sorted(collections):
        print('processing {}...'.format(key))
        newcol = []
        for creative in collections[key]:
            if not creative:
                continue
            if ((prod[key] and
                 creative.get('__product', '') not in allowed_products) or
                'internal-url' not in creative or
                    'filter' not in creative):
                print('throwing away {}'.format(creative.get(
                    'internal-url',
                    'epic shit that doesn\'t even have an internal-url'
                )))
                continue
            else:
                creative['filter'] = fix_bad_products(creative['filter'])
                if creative != check_filter(creative, import_=False):
                    print('modifying filter on {}'.format(
                        creative['internal-url']
                    ))
                newcol.append(check_filter(creative, import_=False))
        print('posting creatives')
        post_creatives(key, newcol, reqtype='put')


if __name__ == "__main__":
    main()
