#!/usr/bin/python
#coding: utf-8
import argparse
import json
import re
from pprint import pprint

from parser_filters import parse, pack


WHITE_LIST_FILTERS = ['ts', 'lang', 'lr', 'referer', 'uat']

TARGETS = {
    "android": {
        "filter": "'#uat:OSFamily,eq,Android'",
        "r": re.compile(".*#(ua|uat:OSFamily),(match|ic_match|eq)[^']*android.*", re.IGNORECASE)
    },
    "ios": {
        "filter": "'#uat:OSFamily,eq,iOS'",
        "r": re.compile(".*#(ua|uat:OSFamily),(match|ic_match|eq)[^']*(iOS|iPhone).*", re.IGNORECASE)
    },
    "iPad": {
        "filter": "'#uat:DeviceName,eq,iPad'",
        "r": re.compile(".*#(ua|uat:DeviceName),(match|ic_match|eq)[^']*iPad.*", re.IGNORECASE)
    }
}

def detect_device_target(banner):
    """Returns optimal filter for device targeting"""
    if "aux-data" in banner and "platform" in banner["aux-data"]:
        if banner["aux-data"]["platform"] in TARGETS:
            return TARGETS[banner["aux-data"]["platform"].lower()]["filter"]
    if 'aux-data' in banner and 'data_for_counter_platform' in banner["aux-data"]:
        return TARGETS[banner["aux-data"]["data_for_counter_platform"].lower()]["filter"]
    for t in TARGETS.values():
        if re.match(t["r"], banner['filter']):
            return t["filter"]


def delete_defaults(f):
    def delete(fi):
        if fi['has_child']:
            fi['parsed'] = filter(delete, fi['parsed'])
            return True
        else:
            for wf in WHITE_LIST_FILTERS:
                if u'#%s' % wf in fi['parsed'][0]:
                    return True

    def filter_analize(filtered):
        filtered = filter(lambda x: len(x['parsed']) != 0, filtered)
        for n, fi in enumerate(filtered):
            if fi['has_child']:
                if len(fi['parsed']) == 1:
                    fi['parsed'] = fi['parsed'][0]['parsed']
                    fi['has_child'] = False
                else:
                    fi['parsed'] = filter_analize(fi['parsed'])
                    if not fi['parsed']:
                        del filtered[n]
            else:
                if n == 0:
                    fi['sign'] = ''
        return filtered
    filtered = filter(delete, parse(f))
    analized = filter_analize(filtered)
    return analized


def filter_filters(input_file_path, output_file_path):
    f = open(input_file_path, "r")
    j = json.loads(f.read())
    for b in j:
        f = parse(b['filter'])
        device_target = detect_device_target(b)
        b['filter'] = pack(delete_defaults(b['filter']))
        if device_target:
            if b['filter']:
                b['filter'] += "&" + device_target
            else:
                b['filter'] = device_target
    output = open(output_file_path, "w")
    output.write(json.dumps(j, ensure_ascii=False, indent=4, sort_keys=True).encode('utf8'))
    output.close()


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--input", type=str, required=True)
    parser.add_argument("--output", type=str, required=True)
    args = parser.parse_args()
    filter_filters(args.input, args.output)
