#!/usr/bin/python
# coding: utf-8
from __future__ import unicode_literals
import argparse
import os

"""Следует делить фильтры на три группы и стараться не пересекать
в одной строке фильтров фильтры из разных групп:
1) Фильтры на реквест (версия ОС, регион, реферер и тд)
2) Фильтры, требующие обращение во внешние источники (apps, products, buckets)
такие как bigB, RTMR
3) Фильтры, требующие вычисления формул (feat)
"""

# SVN_PATH = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/pers/rerank_service/data"
SVN_PATH = "https://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/pers/rerank_service/data/default_filters"
TMP_PATH = "/tmp/rerank_service_data"
try:
    KEY_PATH = open('.key').read()
except:
    KEY_PATH = ''

# Места мобильной дистриубуции пока
PLACE_TARGET = {
    'bannermedia': "ANY\tbannermedia",
    'bannerteaser': "ANY\tbannerteaser",
    'mobilefooter': "ANY\tmobilefooter",
    'smart_banner': "ANY\tsmart_banner",  # done
    'promoliba': "promolib\tANY",
    'promoheader': "ANY\tpromoheader",
    'touch_popup': "ANY\ttouch_popup",
    'splash_screen': "ANY\tsplash_screen",
}


# Фильтры добавленные вручную
STATIC_FILTERS = [
    # {
    #     'product': 'ANY',
    #     'client': 'ANY',
    #     'sub_client': 'ANY',
    #     'filter': "'filter_string'"
    # }
    {
        'product': 'helper',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#lr,eq,187'&'#ys,not_match,yandexhelperext'&(('#uat:BrowserName,eq,YandexBrowser'&'#uat:BrowserVersion,lt,17.4.1')|'#uat:BrowserName,eq,Chrome')&'#uat:isMobile,eq,false'"
    },
    {
        'product': 'taxi',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.ua%'&'#lr,not_eq,187'"
    },
    {
        'product': 'navi',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "('#uat:OSFamily,eq,Android'&'#products,not_match,ru.yandex.yandexnavi')|('#uat:OSFamily,eq,iOS'&'#products,not_match,ru.yandex.mobile.navigator')"
    },
    {
        'product': 'login',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "('#feat:626,eq,0')|('#uat:OSFamily,eq,Android')"
    },
    {
        'product': 'browser',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#yp,not_match,%yb%'&(('#uat:isMobile,eq,false'&'#products,not_match,yabrowser'&'#ua,match,%windows%'&('#yp,not_match,%zmblt%'|'#zmblt,gt,14'))|('#uat:isMobile,eq,true'&'#products,not_match,com.yandex.browser')|('#uat:isMobile,eq,true'&'#products,not_match,ru.yandex.mobilesearch'))&'#ua,ic_not_match,%yabrowser%'"
    },
    {
        'product': 'set_opera',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "('#lang,eq,ru'&'#uat:BrowserName,eq,Opera'&'#uat:BrowserVersion,gt,41.0')|('#lr,eq,225'&'#uat:OSFamily,eq,Android'&(('#uat:BrowserName,eq,OperaMobile'&'#uat:BrowserVersion,gt,37.3')|('#uat:BrowserName,eq,OperaMini'&'#uat:BrowserVersion,gt,20.0')))"
    },
    {
        'product': 'browser_zombie',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#ua,ic_not_match,%yabrowser%'"
    },
    {
        'product': 'set',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#products,not_match,searchextchrome_chr'&'#products,not_match,searchextcomm'&'#products,not_match,homesearchextchrome_chr'&'#products,not_match,startsearchextcomm'&'#uat:BrowserName,eq,Chrome'&'#uat:BrowserVersion,gt,15.0.0'&'#ys,not_match,searchextchrome'&'#ys,not_match,homesearchextchrome'&'#uat:isMobile,eq,false'&'#ua,ic_match,%windows%'"
    },
    {
        'product': 'set',
        'client': 'ANY',
        'sub_client': 'teaser',
        'filter': "'#lr,not_eq,187'&'#referer,not_match,%yandex.ua%'"
    },
    {
        'product': 'sethome',
        'client': 'ANY',
        'sub_client': 'teaser',
        'filter': "'#lr,not_eq,187'&'#referer,not_match,%yandex.ua%'"
    },
    {
        'product': 'home',
        'client': 'ANY',
        'sub_client': 'teaser',
        'filter': "'#lr,not_eq,187'&'#referer,not_match,%yandex.ua%'"
    },
    {
        'product': 'vb',
        'client': 'ANY',
        'sub_client': 'teaser',
        'filter': "'#lr,not_eq,187'&'#referer,not_match,%yandex.ua%'"
    },
    {
        'product': 'set',
        'client': 'ANY',
        'sub_client': 'popup',
        'filter': "'#lr,not_eq,187'&'#referer,not_match,%yandex.ua%'"
    },
    {
        'product': 'sethome',
        'client': 'ANY',
        'sub_client': 'popup',
        'filter': "'#lr,not_eq,187'&'#referer,not_match,%yandex.ua%'"
    },
    {
        'product': 'home',
        'client': 'ANY',
        'sub_client': 'popup',
        'filter': "'#lr,not_eq,187'&'#referer,not_match,%yandex.ua%'"
    },
    {
        'product': 'vb',
        'client': 'ANY',
        'sub_client': 'popup',
        'filter': "'#lr,not_eq,187'&'#referer,not_match,%yandex.ua%'"
    },
    {
        'product': 'sethome',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#products,not_match,startsearchextcomm'&'#products,not_match,homesearchextchrome_chr'&'#uat:BrowserName,eq,Chrome'&'#uat:BrowserVersion,gt,15.0.0'&'#ys,not_match,homesearchextchrome'&'#ys,not_match,startextchrome'&'#ys,not_match,homeext'&'#ys,not_match,searchextchrome'&'#uat:isMobile,eq,false'&'#ua,ic_match,%windows%'"
    },
    {
        'product': 'home',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#products,not_match,startsearchextcomm'&'#products,not_match,startextchrome_chr'&'#products,not_match,homesearchextchrome_chr'&'#products,not_match,homeextchrome_chr'&'#uat:BrowserName,eq,Chrome'&'#uat:BrowserVersion,gt,15.0.0'&'#ys,not_match,startextchrome'&'#ys,not_match,homeext'&'#ys,not_match,homesearchextchrome'&'#uat:isMobile,eq,false'&'#ua,ic_match,%windows%'"
    },
    {
        'product': 'vb',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#products,not_match,vbch'&'#products,not_match,vbff'&'#products,not_match,vbchrome'&'#uat:BrowserName,eq,Chrome'&'#uat:BrowserVersion,gt,15.0.0'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'search',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#products,not_match,ru.yandex.searchplugin'"
    },
    {
        'product': 'browserupdate',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#uat:BrowserName,match,YandexBrowser'&(('#uat:OSFamily,eq,Android'&'#uat:BrowserVersion,lt,17.3.0.373')|('#uat:OSFamily,eq,iOS'&'#uat:BrowserVersion,gt,17.3.2.107'))"
    },
    {
        'product': 'searchline',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#products,not_match,winsearchbar'&('#feat:623,gt,0.96'|'#feat:623,eq,0')"
    },
    {
        'product': 'Telegrambot-afisha',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'Telegrambot-search',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'buy_tickets',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'collections',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'edadil',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'hamovniki',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'money',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'skin',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'sovetnik',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'talk',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'ANY',
        'client': 'distr_portal',
        'sub_client': 'teaser',
        'filter': "('#ts,gt,1494365936'&'#ts,lt,1505235600')|'#ts,gt,1505365200'"
    },
    {
        'product': 'virus',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "('#virus,eq,1'|'#buckets,match,virus')&'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'yad_fines',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'yandexpromo',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'"
    },
    {
        'product': 'ANY',
        'client': 'distr_portal',
        'sub_client': 'touch_popup',
        'filter': "('#feat:564,gt,0.9863'|'#feat:564,eq,0')&('#feat:527,gt,0.9986'|'#feat:527,eq,0')&('#feat:614,gt,0.96'|'#feat:614,eq,0')"
    },
    {
        'product': 'ANY',
        'client': 'distr_portal',
        'sub_client': 'popup',
        'filter': "('#feat:564,gt,0.9863'|'#feat:564,eq,0')&('#feat:527,gt,0.16'|'#feat:527,eq,0')&('#feat:614,gt,0.96'|'#feat:614,eq,0')&'#ts,gt,1482786000'&'#referer,not_match,%nl=1%'&'#referer,not_match,%nl=1'"
    },
    {
        'product': 'ANY',
        'client': 'distr_portal',
        'sub_client': 'bannerteaser',
        'filter': "'#uat:isTablet,eq,false'"
    },
    {
        'product': 'ANY',
        'client': 'distr_serp',
        'sub_client': 'wizard',
        'filter': "('#feat:614,gt,0.96'|'#feat:614,eq,0')&('#feat:564,gt,0.9863'|'#feat:564,eq,0')&('#feat:527,gt,0.16'|'#feat:527,eq,0')&'#referer,not_match,%nl=1%'&'#referer,not_match,%nl=1'"
    },
    {
        'product': 'ANY',
        'client': 'distr_serp',
        'sub_client': 'stripe',
        'filter': "('#feat:564,gt,0.9863'|'#feat:564,eq,0')&('#feat:527,gt,0.16'|'#feat:527,eq,0')&'#referer,not_match,%nl=1%'&'#referer,not_match,%nl=1'"
    },
    {
        'product': 'ANY',
        'client': 'daas',
        'sub_client': 'stripe',
        'filter': "('#feat:626,gt,0.96'|'#feat:626,eq,0')&('#feat:527,gt,0.16'|'#feat:527,eq,0')&'#referer,not_match,%www.kinopoisk.ru%'&('#feat:614,gt,0.96'|'#feat:614,eq,0')&'#yp,not_match,%.los.1%'&'#yp,not_match,%.los.1'"
    },
    {
        'product': 'ANY',
        'client': 'daas',
        'sub_client': 'popup',
        'filter': "('#feat:626,gt,0.96'|'#feat:626,eq,0')&('#feat:527,gt,0.16'|'#feat:527,eq,0')&'#referer,not_match,%www.kinopoisk.ru%'&('#feat:614,gt,0.96'|'#feat:614,eq,0')&'#yp,not_match,%.los.1%'&'#yp,not_match,%.los.1'"
    },
    {
        'product': 'ANY',
        'client': 'promolib',
        'sub_client': 'ANY',
        'filter': "'#referer,not_match,ru.yandex.metro%'&'#referer,not_match,ru.yandex.mobile.metro%'&(('#feat:527,eq,0')|('#feat:527,gt,0.75')|('#referer,match,ru.yandex.mail%')|('#referer,match,ru.yandex.translate%')|('#referer,match,ru.yandex.mobile.translate%')|('#referer,match,ru.yandex.test.promolib%')|('#referer,match,ru.yandex.promolib.sample%'))"
    },
    {
        'product': 'ANY',
        'client': 'distr_serp',
        'sub_client': 'ANY',
        'filter': "'#buckets,not_match,jobs_sysadm'&'#buckets,not_match,block_distribution'&('#feat:626,gt,0.96'|'#feat:626,eq,0')"
    },
    {
        'product': 'ANY',
        'client': 'ANY',
        'sub_client': 'popup',
        'filter': "'#buckets,not_match,jobs_sysadm'&'#buckets,not_match,block_distribution'&('#feat:562,gt,0.9863'|'#feat:562,eq,0')&('#feat:527,gt,0.16'|'#feat:527,eq,0')&('#feat:614,gt,0.96'|'#feat:614,eq,0')"
    },
    {
        'product': 'ANY',
        'client': 'ANY',
        'sub_client': 'smart_banner',
        'filter': "'#slowconn,not_eq,1'&'#ys,match,%'&'#feat:499,lt,0.98'&'#ua,ic_not_match,%YandexSearch%'&'#ua,ic_not_match,%yandex search plugin%'&'#ua,ic_not_match,yandexsearch%'&'#ua,ic_not_match,%YaApp%'&'#ua,ic_not_match,%yaapp_ios%'&'#uat:BrowserName,not_match,YandexSearch'&(('#feat:499,lt,0.8'&'#uat:OSFamily,eq,iOS')|'#uat:OSFamily,not_eq,iOS')&'#referer,ic_not_match,%clid=2279161%'&'#referer,ic_not_match,%clid=2270398%'&'#referer,ic_not_match,%clid=2279177%'&'#referer,ic_not_match,%clid=2285017%'&'#referer,ic_not_match,%clid=2285018%'&'#referer,ic_not_match,%clid=2286502%'&'#referer,ic_not_match,%clid=2279161'&'#referer,ic_not_match,%clid=2270398'&'#referer,ic_not_match,%clid=2279177'&'#referer,ic_not_match,%clid=2285017'&'#referer,ic_not_match,%clid=2285018'&'#referer,ic_not_match,%clid=2286502'&'#referer,not_match,%adresa-geolocation%'&'#referer,not_match,https://m.news.yandex.ru/turbo/%'"
    },
    {
        'product': 'ANY',
        'client': 'distr_serp',
        'sub_client': 'smart_banner',
        'filter': "('#feat:564,gt,0.9941'|'#feat:564,eq,0')&('#feat:614,gt,0.96'|'#feat:614,eq,0')"
    },
    {
        'product': 'ANY',
        'client': 'ANY',
        'sub_client': 'splash_screen',
        'filter': "'#slowconn,not_eq,1'&'#ys,match,%'&'#feat:499,lt,0.98'&'#ua,ic_not_match,%YandexSearch%'&'#ua,ic_not_match,%yandex search plugin%'&'#ua,ic_not_match,yandexsearch%'&'#ua,ic_not_match,%YaApp%'&'#ua,ic_not_match,%yaapp_ios%'&'#uat:BrowserName,not_match,YandexSearch'&(('#feat:499,lt,0.8'&'#uat:OSFamily,eq,iOS')|'#uat:OSFamily,not_eq,iOS')&'#referer,ic_not_match,%clid=2279161%'&'#referer,ic_not_match,%clid=2270398%'&'#referer,ic_not_match,%clid=2279177%'&'#referer,ic_not_match,%clid=2285017%'&'#referer,ic_not_match,%clid=2285018%'&'#referer,ic_not_match,%clid=2286502%'&'#referer,ic_not_match,%clid=2279161'&'#referer,ic_not_match,%clid=2270398'&'#referer,ic_not_match,%clid=2279177'&'#referer,ic_not_match,%clid=2285017'&'#referer,ic_not_match,%clid=2285018'&'#referer,ic_not_match,%clid=2286502'&'#referer,not_match,%adresa-geolocation%'&'#referer,not_match,https://m.news.yandex.ru/turbo/%'"
    },
    {
        'product': 'ANY',
        'client': 'distr_serp',
        'sub_client': 'splash_screen',
        'filter': "('#feat:564,gt,0.9941'|'#feat:564,eq,0')&('#feat:614,gt,0.96'|'#feat:614,eq,0')"
    },
    {
        'product': 'ANY',
        'client': 'ANY',
        'sub_client': 'promoheader',
        'filter': "'#slowconn,not_eq,1'&'#ys,match,%'&'#feat:499,lt,0.98'&'#ua,ic_not_match,%YandexSearch%'&'#ua,ic_not_match,%yandex search plugin%'&'#ua,ic_not_match,yandexsearch%'&'#ua,ic_not_match,%YaApp%'&'#ua,ic_not_match,%yaapp_ios%'&'#uat:BrowserName,not_match,YandexSearch'&(('#feat:499,lt,0.8'&'#uat:OSFamily,eq,iOS')|'#uat:OSFamily,not_eq,iOS')&'#referer,ic_not_match,%clid=2279161%'&'#referer,ic_not_match,%clid=2270398%'&'#referer,ic_not_match,%clid=2279177%'&'#referer,ic_not_match,%clid=2285017%'&'#referer,ic_not_match,%clid=2285018%'&'#referer,ic_not_match,%clid=2286502%'&'#referer,ic_not_match,%clid=2279161'&'#referer,ic_not_match,%clid=2270398'&'#referer,ic_not_match,%clid=2279177'&'#referer,ic_not_match,%clid=2285017'&'#referer,ic_not_match,%clid=2285018'&'#referer,ic_not_match,%clid=2286502'"
    },
    {
        'product': 'ANY',
        'client': 'distr_serp',
        'sub_client': 'promoheader',
        'filter': "('#feat:564,gt,0.9941'|'#feat:564,eq,0')&('#feat:614,gt,0.96'|'#feat:614,eq,0')"
    },
    {
        'product': 'ANY',
        'client': 'ANY',
        'sub_client': 'bannermedia',
        'filter': "'#uat:isTablet,eq,false'"
    },
    {
        'product': 'promoquery',
        'client': 'ANY',
        'sub_client': 'ANY',
        'filter': "'#lr,eq,225'&'#referer,match,%yandex.ru/search%'"
    },
    ]

# конфиг мобильных продуктов
MOBILE_PRODUCTS = [
    #__product имя продукта в баннерах
    # {"names": ['search', 'appsearch', 'searchapp'],
    # "title": u"Поисковое приложение Яндекс",
    # "bigb": None,
    # "bigb_android": 62,
    # "bigb_ios": 64,
    # "bigb_windows": None,
    # "ios_min_version": '8.1',
    # "android_min_version": '4.1',
    # "windows_min_version": None,
    # "ios_package": 'ru.yandex.mobile',
    # "android_package": 'ru.yandex.searchplugin',
    # "other": None,
    # "places": ['bannermedia', 'bannerteaser', 'mobilefooter', 'smart_banner', 'promoliba', 'splash_screen']},
    {
        #__product name and synonymous
        "names": ['search', 'appsearch', 'searchapp'],
        "title": u"Поисковое приложение Яндекс",
        "bigb": None,
        "bigb_android": 62,
        "bigb_android_tablet": None,
        "bigb_ios": 64,
        "bigb_ipad": None,
        "bigb_windows": 40,
        "ios_min_version": '8.1',
        "android_min_version": '4.1',
        "ios_package": 'ru.yandex.mobile',
        "ipad_package": None,
        "android_package": 'ru.yandex.searchplugin',
        "other_filters": {
            "flt1": "'#ua,ic_not_match,%YandexSearch%'&'#ua,ic_not_match,%yabrowser%'&'#ua,ic_not_match,%yandex search plugin%'&'#ua,ic_not_match,yandexsearch%'&'#ua,ic_not_match,%YaApp%'&'#ua,ic_not_match,%yaapp_ios%'&'#uat:BrowserName,not_match,YandexSearch'&'#uat:BrowserName,not_match,YandexBrowser'",
            "flt2": '',
            "flt3": ''
        },
        "other": ['windows_default_filters'],
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter', 'smart_banner', 'promoheader', 'splash_screen']},
    {
        "names": ['browser', 'mobbrowser'],
        "title": u"Yandex Browser",
        "bigb": None,
        "bigb_android": 5,
        "bigb_android_tablet": 6,
        "bigb_ios": 7,
        "bigb_ipad": 8,
        "bigb_windows": None,
        "ios_min_version": '7.0',
        "android_min_version": '4.1',
        "ios_package": 'ru.yandex.mobile.search',
        "ipad_package": 'ru.yandex.mobile.search.ipad',
        "android_package": 'com.yandex.browser',
        "other_filters": {
            "flt1": "'#ua,ic_not_match,%YandexSearch%'&'#ua,ic_not_match,%yabrowser%'&'#ua,ic_not_match,%yandex search plugin%'&'#ua,ic_not_match,yandexsearch%'&'#ua,ic_not_match,%YaApp%'&'#ua,ic_not_match,%yaapp_ios%'&'#uat:BrowserName,not_match,YandexSearch'&'#uat:BrowserName,not_match,YandexBrowser'",
            "flt2": '',
            "flt3": ''
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter', 'smart_banner', 'promoheader', 'splash_screen']},
    {
        "names": ['browserlite'],
        "title": u"Yandex Browser Lite",
        "bigb": None,
        "bigb_android": 79,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": None,
        "android_min_version": '4.1',
        "ios_package": None,
        "ipad_package": None,
        "android_package": 'com.yandex.browser.lite',
        "promoliba":{
            "flt1": "'#uat:OSFamily,eq,Android'&'#uat:isTablet,eq,false'&'#uat:OSVersion,lt,4.5'&'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#uat:OSFamily,eq,Android'&'#uat:isTablet,eq,false'&'#uat:OSVersion,lt,4.5'&'#ua,ic_not_match,%YandexSearch%'&'#ua,ic_not_match,%yabrowser%'&'#ua,ic_not_match,%yandex search plugin%'&'#ua,ic_not_match,yandexsearch%'&'#ua,ic_not_match,%YaApp%'&'#ua,ic_not_match,%yaapp_ios%'&'#uat:BrowserName,not_match,YandexSearch'&'#uat:BrowserName,not_match,YandexBrowser'&'#uat:BrowserName,not_match,YandexBrowserLite'",
            "flt2": '',
            "flt3": ''
        },
        "other": None,
        "places": ['promoliba', 'smart_banner', 'mobilefooter', 'splash_screen']},
    {
        "names": ['launcher'],
        "title": u"Yandex Launcher",
        "bigb": None,
        "bigb_android": 65,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": None,
        "android_min_version": '4.1',
        "ios_package": None,
        "ipad_package": None,
        "android_package": 'com.yandex.launcher',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','smart_banner', 'splash_screen']},
    {
        "names": ['maps'],
        "title": u"Yandex Maps",
        "bigb": [14, 15],
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '9.0',
        "android_min_version": '4.0.3',
        "ios_package": 'ru.yandex.traffic',
        "ipad_package": None,
        "android_package": 'ru.yandex.yandexmaps',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "",
            "flt2": "",
            "flt3": ""
        },
        "other": ['windows_default_filters'],
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter', 'promoliba', 'smart_banner', 'splash_screen']},
    {
        "names": ['taxi'],
        "title": u"Yandex Taxi",
        "bigb": 3,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '8.0',
        "android_min_version": '4.0.3',
        "ios_package": 'ru.yandex.ytaxi',
        "ipad_package": None,
        "android_package": 'ru.yandex.taxi',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'&'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": ['windows_default_filters'],
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba', 'smart_banner', 'splash_screen']},
    {
        "names": ['music'],
        "title": u"Yandex Music",
        "bigb": [20, 21, 22, 23],
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '9.0',
        "android_min_version": '4.1',
        "ios_package": 'ru.yandex.mobile.music',
        "ipad_package": None,
        "android_package": 'ru.yandex.music',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['auto', 'autoru'],
        "title": u"Auto.ru",
        "bigb": 43,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '8.0',
        "android_min_version": '4.0.3',
        "ios_package": "ru.autoru",
        "ipad_package": None,
        "android_package": 'ru.yandex.auto',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['navi'],
        "title": u"Яндекс Навигатор",
        "bigb": 42,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '8.0',
        "android_min_version": '4.2',
        "ios_package": 'ru.yandex.mobile.navigator',
        "ipad_package": None,
        "android_package": 'ru.yandex.yandexnavi',
        "other_filters": {
            "flt1": "",
            "flt2": "",
            "flt3": ""
        },
        "other": ['windows_default_filters'],
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promolib']},
    {
        "names": ['avia'],
        "title": u"Яндекс Авиабилеты",
        "bigb": 72,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '7.0',
        "android_min_version": '4.2',
        "ios_package": 'ru.yandex.mobile.avia',
        "ipad_package": None,
        "android_package": 'ru.yandex.mobile.avia',
        "other_filters": "",
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['mail'],
        "title": u"Яндекс Почта",
        "bigb": None,
        "bigb_android": 13,
        "bigb_android_tablet": None,
        "bigb_ios": 46,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '7.1',
        "android_min_version": '4.0.3',
        "ios_package": 'ru.yandex.mail',
        "ipad_package": None,
        "android_package": 'ru.yandex.mail',
        "other_filters": "",
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "",
            "flt2": "",
            "flt3": ""
        },
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['kinopoisk'],
        "title": u"Кинопоиск",
        "bigb": 36,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '7.0',
        "android_min_version": '4.2',
        "ios_package": 'ru.kinopoisk',
        "ipad_package": None,
        "android_package": 'ru.kinopoisk',
        "other_filters": "",
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['market'],
        "title": u"Яндекс Маркет",
        "bigb": None,
        "bigb_android": 16,
        "bigb_android_tablet": None,
        "bigb_ios": 17,
        "bigb_ipad": None,
        "bigb_windows": 18,
        "ios_min_version": '7.0',
        "android_min_version": '4.0.3',
        "ios_package": 'ru.yandex.ymarket',
        "ipad_package": None,
        "android_package": 'ru.yandex.market',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['radio'],
        "title": u"Яндекс Радио",
        "bigb": 73,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '8.0',
        "android_min_version": '4.1',
        "ios_package": 'ru.yandex.mobile.radio',
        "ipad_package": None,
        "android_package": 'ru.yandex.radio',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['odezhda'],
        "title": u"Яндекс Одежда",
        "bigb": 74,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '8.1',
        "android_min_version": None,
        "ios_package": 'ru.yandex.ymarket.putoffclothes',
        "ipad_package": None,
        "android_package": None,
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['pogoda', 'weather'],
        "title": u"Яндекс Погода",
        "bigb": 29,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '7.0',
        "android_min_version": '4.2',
        "ios_package": 'ru.yandex.mobile.weather-v2',
        "ipad_package": 'ru.yandex.mobile.weather',
        "android_package": 'ru.yandex.weatherplugin',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['shortcut'],
        "title": u"Яндекс Ярлык",
        "bigb": None,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": None,
        "android_min_version": None,
        "ios_package": None,
        "ipad_package": None,
        "android_package": None,
        "promoliba":{
            "flt1": "'#uat:OSFamily,eq,Android'&'#req:api_level,gt,240'",
            "flt2": "'#products,not_match,com.yandex.browser'&'#products,not_match,ru.yandex.mobilesearch'&'#products,not_match,ru.yandex.searchplugin'",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['promoliba']},
    {
        "names": ['default_search_mobilesafari_ios'],
        "title": u"Дефолтный поиск в iOS",
        "bigb": None,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": None,
        "android_min_version": None,
        "ios_package": "default_search_mobilesafari_ios",
        "ipad_package": None,
        "android_package": None,
        "promoliba":{
            "flt1": "",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#uat:BrowserName,eq,MobileSafari'&'#referer,not_match,%clid=1906722%'&'#referer,not_match,%clid=1906722'&'#referer,not_match,%clid=1906591%'&'#referer,not_match,%clid=1906591'&'#referer,not_match,%clid=2192578%'&'#referer,not_match,%clid=2192578'&'#referer,not_match,%clid=1906597%'&'#referer,not_match,%clid=1906597'&'#products,not_match,default_search_mobilesafari_ios'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['promoliba','smart_banner', 'promoheader', 'touch_popup', 'splash_screen']},
    {
        "names": ['transport'],
        "title": u"Яндекс Транспорт",
        "bigb": 28,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '7.1',
        "android_min_version": '4.2',
        "ios_package": 'ru.yandex.mobile.transport',
        "ipad_package": None,
        "android_package": 'ru.yandex.yandexbus',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.ua%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter', 'promoliba']},
    {
        "names": ['realty'],
        "title": u"Яндекс Недвижимость",
        "bigb": 63,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '7.0',
        "android_min_version": '4.0.3',
        "ios_package": 'ru.yandex.mobile.realty',
        "ipad_package": None,
        "android_package": 'com.yandex.mobile.realty',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['health'],
        "title": u"Яндекс.Здоровье",
        "bigb": None,
        "bigb_android": 76,
        "bigb_android_tablet": None,
        "bigb_ios": 75,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '8.0',
        "android_min_version": '4.0',
        "ios_package": 'ru.yandex.mobile.medicine',
        "ipad_package": None,
        "android_package": 'ru.yandex.med',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannerteaser', 'mobilefooter','promoliba']},
    {
        "names": ['rasp'],
        "title": u"Яндекс Расписания",
        "bigb": None,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '8.0',
        "android_min_version": '4.0.3',
        "ios_package": 'ru.yandex.rasp',
        "ipad_package": None,
        "android_package": 'ru.yandex.rasp',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['promoliba', 'bannermedia', 'bannerteaser', 'mobilefooter','promoliba']
    },
    {
        "names": ['keyboard'],
        "title": u"Яндекс Клавиатура",
        "bigb": None,
        "bigb_android": 77,
        "bigb_android_tablet": None,
        "bigb_ios": 77,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '8.0',
        "android_min_version": '4.0.3',
        "ios_package": 'ru.yandex.mobile.keyboard',
        "ipad_package": None,
        "android_package": 'ru.yandex.androidkeyboard',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['bannermedia', 'bannerteaser', 'mobilefooter','promoliba']
    },
    {
        "names": ['disk'],
        "title": u"Яндекс.Диск",
        "bigb": None,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": None,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": None,
        "android_min_version": None,
        "ios_package": None,
        "ipad_package": None,
        "android_package": 'ru.yandex.disk',
        "promoliba":{
            "flt1": "'#referer,not_match,ru.yandex.yandexnavi%'&'#referer,not_match,ru.yandex.mobile.navigator%'&'#referer,not_match,ru.yandex.traffic%'&'#referer,not_match,ru.yandex.yandexmaps%'&'#referer,not_match,ru.yandex.mobile.transport%'&'#referer,not_match,ru.yandex.yandexbus%'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "'#referer,not_match,%yandex.by%'&'#referer,not_match,%yandex.ua%'&'#referer,not_match,%yandex.kz%'&'#referer,not_match,%yandex.com.tr%'",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['mobilefooter', 'promoliba']},
    {
        "names": ['widgetios'],
        "title": u"Виджет для ios. PERSONAL-1535",
        "bigb": None,
        "bigb_android": None,
        "bigb_android_tablet": None,
        "bigb_ios": 78,
        "bigb_ipad": None,
        "bigb_windows": None,
        "ios_min_version": '8.0',
        "android_min_version": None,
        "ios_package": 'ru.yandex.traffic.searchwidget',
        "ipad_package": None,
        "android_package": None,
        "promoliba":{
            "flt1": "'#referer,match,ru.yandex.traffic%'&'#req:app_version_name,gt,9.3'",
            "flt2": "",
            "flt3": ""
        },
        "other_filters": {
            "flt1": "",
            "flt2": "",
            "flt3": ""
        },
        "other": None,
        "places": ['promoliba']},
]


def generate_goals_bb_apikeys():
    a = []
    for bb in APIKEY_BB:
        for apikey in APIKEY_APPNAME:
            if bb[0] == apikey[0]:
                a.append({
                    "bb": bb[1],
                    "name": apikey[1],
                    "apikey": bb[0]
                })
    return a


def os_condition(os_v, is_ios=False):
    """Хак для избежания проблем со сравнивание версий в атоме (depricated)"""
    splited = os_v.split('.')
    if len(splited) > 2:
        os_v = "%s.%d" % (splited[0], int(splited[1]) + 1)
    f = "'#uat:OSVersion,gt,{0}'|'#uat:OSVersion,gt,{1}'".format(
        os_v + '.0', os_v)
    if is_ios:
        f += "|(('#uat:OSVersion,gt,10.0'|'#uat:OSVersion,gt,10.0.0')&'#uat:OSVersion,match,1%')"
    f = "(%s)" % f
    return f


def generate_static_filters(filters=STATIC_FILTERS):
    """Генератор фильтров, заданных в конфиге"""
    output = ''
    for f in filters:
        output += "%s\t%s\t%s\t%s\n" % (f['product'],
                                        f['client'],
                                        f['sub_client'],
                                        f['filter'])
    return output


def generate_mobile_filters(apps=MOBILE_PRODUCTS, clients='all', products='all'):
    """Генератор фильтров для мобильных продуктов для определенных баннерных мест"""
    def non_empty_keys(d):
        return filter(lambda x: d[x] != u'', d.keys())

    filters = ''
    os_condition = "'#uat:OSFamily,eq,%s'"
    ver_condition = "'#uat:OSVersion,gt,%s'"
    apps_condition = "'#apps,not_match,%d'"
    products_condition = "'#products,not_match,%s'"
    device_condition = "'#uat:DeviceName,eq,%s'"
    for app in apps:
        for product_name in app['names']:
            if products != 'all':
                if product_name not in products:
                    continue
            for place in app['places']:
                if clients != 'all':
                    if place not in clients:
                        continue
                flt1 = {
                    'ios': '',
                    'ipad': '',
                    'android': ''
                }
                flt2 = {
                    'ios': '',
                    'ipad': '',
                    'android': ''
                }
                head = "%s\t%s" % (product_name, PLACE_TARGET[place])
                if app['ios_min_version'] is not None:
                    _os = os_condition % 'iOS'
                    _ver = ver_condition % app['ios_min_version']
                    flt1['ios'] = "%s&%s" % (_os, _ver)
                    if app['bigb_ios']:
                        _apps = apps_condition % app['bigb_ios']
                    if app['ios_package']:
                        _products = products_condition % app['ios_package']
                    if app['bigb_ios'] or app['ios_package']:
                        flt2['ios'] = _os
                        if app['bigb_ios']:
                            flt2['ios'] += "&%s" % _apps
                        if app['ios_package']:
                            flt2['ios'] += "&%s" % _products

                if app['ipad_package'] is not None:
                    _device = device_condition % 'iPad'
                    _ver = ver_condition % app['ios_min_version']
                    flt1['ipad'] = "%s&%s" % (_device, _ver)
                    if app['bigb_ipad']:
                        _apps = apps_condition % app['bigb_ipad']
                    if app['ipad_package']:
                        _products = products_condition % app['ipad_package']
                    if app['bigb_ipad'] or app['ipad_package']:
                        flt2['ipad'] = _device
                        if app['bigb_ipad']:
                            flt2['ipad'] += "&%s" % _apps
                        if app['ipad_package']:
                            flt2['ipad'] += "&%s" % _products

                if app['android_min_version']:
                    _os = os_condition % 'Android'
                    _ver = ver_condition % app['android_min_version']
                    flt1['android'] = "%s&%s" % (_os, _ver)
                    if app['bigb_android']:
                        _apps = apps_condition % app['bigb_android']
                        if app['bigb_android_tablet']:
                            _apps += "&" + \
                                apps_condition % app['bigb_android_tablet']
                    if app['android_package']:
                        _products = products_condition % app['android_package']
                    if app['bigb_android'] or app['android_package']:
                        flt2['android'] = _os
                        if app['bigb_android']:
                            flt2['android'] += "&%s" % _apps
                        if app['android_package']:
                            flt2['android'] += "&%s" % _products

                flt1_keys = non_empty_keys(flt1)
                flt1_filters = ''
                if flt1_keys:
                    if len(flt1_keys) > 1:
                        flt1_filters = "(%s)" % "|".join(
                            "(%s)" % flt1[k] for k in flt1_keys)
                    else:
                        flt1_filters = flt1[flt1_keys[0]]
                if place == 'promoliba':

                    if 'promoliba' in app:
                        if app['promoliba']['flt1']:
                            if flt1_filters:
                                flt1_filters += '&' + app['promoliba']['flt1']
                            else:
                                flt1_filters += app['promoliba']['flt1']
                else:
                    if app['other_filters']['flt1']:
                        if flt1_filters:
                            flt1_filters += '&' + app['other_filters']['flt1']
                        else:
                            flt1_filters = app['other_filters']['flt1']
                if flt1_filters:
                    filters += "%s\t%s\n" % (head, flt1_filters)

                flt2_filters = ''
                flt2_keys = non_empty_keys(flt2)
                #@TODO подумать что делать с пустыпи flt2
                if flt2_keys:
                    if len(flt2_keys) > 1:
                        flt2_filters = "(%s)" % "|".join(
                            "(%s)" % flt2[k] for k in flt2_keys)
                    else:
                        flt2_filters = flt2[flt2_keys[0]]
                if app['bigb']:
                    if type(app['bigb']) == list:
                        for a in app['bigb']:
                            flt2_filters += "&" + apps_condition % a
                    else:
                        flt2_filters += "&" + apps_condition % app['bigb']

                if place == 'promoliba':
                    if 'promoliba' in app:
                        if app['promoliba']['flt2']:
                            if flt2_filters:
                                flt2_filters += '&' + app['promoliba']['flt2']
                            else:
                                flt2_filters += app['promoliba']['flt2']
                else:
                    if app['other_filters']['flt2']:
                        if flt2_filters:
                            flt2_filters += '&' + app['other_filters']['flt2']
                        else:
                            flt2_filters += app['other_filters']['flt2']

                if flt2_filters:
                    filters += "%s\t%s\n" % (head, flt2_filters)

                if place == 'promoliba':
                    if 'promoliba' in app:
                        if app['promoliba']['flt3']:
                            filters += "%s\t%s\n" % (head,
                                                     app['promoliba']['flt3'])
                else:
                    if app['other_filters']['flt3']:
                        filters += "%s\t%s\n" % (head,
                                                 app['other_filters']['flt3'])

    return filters


def generate_filters(static=True, mobile_products=[], mobile_clients=[]):
    output = ''
    if static:
        output = output + generate_static_filters()
    if mobile_products:
        output = output + \
            generate_mobile_filters(
                clients=mobile_clients, products=mobile_products)
    return output


# def commit(filters, message):
#     if KEY_PATH:
#         os.system('SVN_SSH="ssh -i {}" '.format(KEY_PATH.rstrip()))
#     un = '--username robot-atom-releases ' if KEY_PATH else ''
#     os.system('echo $SVN_SSH')
#     os.system("rm -rf %s" % TMP_PATH)
#     print("svn %sco %s %s" % (un, SVN_PATH, TMP_PATH))
#     os.system("svn %sco %s %s" % (un, SVN_PATH, TMP_PATH))
#     f = open("%s/default_filters.txt" % TMP_PATH, "w")
#     f.write(filters)
#     f.close()
#     os.system("svn %sci -m '%s' %s/default_filters.txt" %
#         (un, message, TMP_PATH)
#     )
#     if KEY_PATH:
#         os.system('export SVN_SSH=""')

def commit(filters, message):
    os.system("rm -rf %s" % TMP_PATH)
    os.system("svn co %s %s" % (SVN_PATH, TMP_PATH))
    f = open("%s/default.txt" % TMP_PATH, "w")
    f.write(filters)
    f.close()
    print "Commit commamd: svn ci -m '%s' %s/default.txt" % (message, TMP_PATH)
    os.system("svn ci -m '%s' %s/default.txt" % (message, TMP_PATH))


def build():
    print """
    Go to https://sandbox.yandex-team.ru/task/86716494/view
    Click CLONE button, change description
    Click RUN to start building of resources
    Click RELEASE to deploy resources to cluster

    AHTUNG!!!
    Commit your changes in filter_generator.py:
        svn ci -m 'YOUR MESSAGE HERE' filter_generator.py
    """

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument("-p", required=False,
                        help="Printing", action='store_true')
    parser.add_argument("-c", required=False,
                        help="Commit", action='store_true')
    parser.add_argument("-m", type=str, required=False, help="Commit message")
    parser.add_argument("-b", required=False,
                        help="Show build task link", action='store_true')
    parser.add_argument("-a", required=False,
                        help="Do everything for me", action='store_true')

    args = parser.parse_args()
    filters = generate_filters(static=True, mobile_products='all', mobile_clients=[
                               'smart_banner', 'bannermedia', 'bannerteaser', 'mobilefooter', 'promoliba', 'promoheader', 'touch_popup', 'splash_screen'])
    if args.p:
        print filters
    if args.m:
        message = args.m
    else:
        message = "Added some changes to default_filters"
    if args.c:
        commit(filters, message)
    if args.b:
        build()
    if args.a:
        print filters
        commit(filters, message)
        build()
