import argparse
import json
import re

from parser_filters import parse, pack, ClothingBracketsNotFound, WrongTerm


def validate(input_file_path):
    f = open(input_file_path, "r")
    j = json.loads(f.read())
    for b in j:
        try:
            f = parse(b['filter'])
        except ClothingBracketsNotFound as e:
            print """
    Can't find closing bracket here %s
    in banner %s
    with filter
    %s
            """ % (e.value, b['internal-url'], b['filter'])
        except WrongTerm as e:
            print """
    Error with filter term  %s
    in banner %s
    with filter
    %s
            """ % (e.value, b['internal-url'], b['filter'])


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--input", type=str, required=True)
    args = parser.parse_args()
    validate(args.input)
