#!/usr/bin/python
# -*- coding: UTF-8 -*-

import json
import nile
import pandas as pd
import shlex
import subprocess
import urlparse
from argparse import ArgumentParser
from collections import defaultdict, namedtuple
from nile.api.v1 import (
    clusters,
    Record
)


class Atomhelper:
    def __init__(self, date, yandexuid):
        self.username = 'chikachoff'
        self.date = date
        self.yandexuid = yandexuid
        self.intable = "//logs/atomfront-reqans-log/1d/{}".format(self.date)

    def _filter(self, records):
        for rec in records:
            if self.yandexuid in rec.get('yandexUid', {}):
                yield rec

    def filter_log(self):
        results = []
        cluster = clusters.Hahn(
            pool='search-research_{}'.format(self.username),
            token='AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
        ).env(
            templates=dict(
                job_root='home/atom/humanized'
            )
        )
        job = cluster.job()
        atomlog = job.table(self.intable)
        atomlog_parsed = atomlog.map(self._filter)
        result = atomlog_parsed.put(
            "//home/atom/chikachoff/yandexuid_search/{}".format(self.yandexuid)
        )
        results.append(result)
        job.run()
        print 'Filter atom-log done.'

def main():
    parser = ArgumentParser()
    parser.add_argument("--date", "-d")
    parser.add_argument("--yandexuid", "-y")
    args = parser.parse_args()
    atom = Atomhelper(date=args.date, yandexuid=args.yandexuid)
    atom.filter_log()

if __name__ == '__main__':
    main()
