#!/usr/bin/python
# -*- coding: UTF-8 -*-

import nile
from argparse import ArgumentParser
from nile.api.v1 import (
    clusters,
    Record
)


class Atomhelper:
    def __init__(self, date, time, yandexuid):
        self.username = 'chikachoff'
        self.date = date
        self.time = time
        self.yandexuid = yandexuid
        self.intable = "//logs/atomfront-reqans-log/stream/5min/{}T{}".format(self.date, self.time)
        self.outtable = "//home/atom/{USERNAME}/yandexuid_search/{YANDEXUID}_{TIME}".format(USERNAME=self.username, YANDEXUID=self.yandexuid, TIME=self.time)

    def _filter(self, records):
        for rec in records:
            if self.yandexuid in rec.get('yandexUid', {}):
                yield rec

    def filter_log(self):
        cluster = clusters.Hahn(
            pool='search-research_{}'.format(self.username),
            token='AVImKQMAAAO3VDAg54V4QjeI8eaNZJSQfA'
        ).env(
            templates=dict(
                job_root='home/atom/humanized'
            )
        )
        job = cluster.job()
        atomlog = job.table(self.intable)\
                     .map(self._filter)\
                     .put(self.outtable)
        job.run()
        print 'Filter atom-log done.\nPlease see results at: {}'.format(self.outtable)

def main():
    parser = ArgumentParser()
    parser.add_argument("--date", "-d")
    parser.add_argument("--time", "-t")
    parser.add_argument("--yandexuid", "-y")
    args = parser.parse_args()
    atom = Atomhelper(date=args.date, time=args.time, yandexuid=args.yandexuid)
    atom.filter_log()

if __name__ == '__main__':
    main()
