# -*- coding: utf-8 -*-

import argparse
from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)
import sys
import nile
import json
from getpass import getuser

# Config
username = getuser()
cluster = clusters.Hahn(pool = 'search-research_{}'.format(username))

def mapper(rows):
    for row in rows:
        try:
            if row['client'] == client:
                ua_traits = json.loads(row["rest"]["propsJson"])['ua-traits']
                for answer in row["rest"].get('answers', []):
                    if answer['name'] == sub_client:
                        props=answer["auxInfo"]["propsJson"]
                        last = json.loads(props).get("filtering-results", ['empty'])[-1]
                        if last == 'subst:0':
                            ua_traits_str = "\n".join(["{}={}".format(key, ua_traits[key]) for key in sorted(ua_traits.keys())])
                            yield Record(ua_traits=ua_traits_str, **{one: row[one] for one in ['lang', 'region']})
        except Exception, e:
            sys.stderr.write('ERROR: {}'.format(str(e)))

def errors_in_last_table():
    job = cluster.job()
    out_table = "//home/atom/{}/grepped_subst_errors".format(username)
    table = job.cumulative_table("//logs/atomfront-reqans-log/stream/5min") \
                .map(mapper) \
                .groupby("lang", "region", "ua_traits") \
                .aggregate(count=na.count()) \
                .sort('count') \
                .put(out_table)
    job.run()
    print(r"Out table: https://yt.yandex-team.ru/hahn/#page=navigation&path={}&pageSize=200&offsetMode=row".format(out_table))

def main():
    global client, sub_client
    parser = argparse.ArgumentParser()
    parser.add_argument('--client', action='store')
    parser.add_argument('--sub_client', action='store')
    args = parser.parse_args()
    if not args.client or not args.sub_client:
        raise Exception("specify client and sub_client")
    client, sub_client = args.client, args.sub_client
    errors_in_last_table()

if __name__ == '__main__':
    main()
