#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import division

import argparse
import codecs
import datetime
import hashlib
import json
import os
import subprocess
import sys
import time
from copy import deepcopy

from places.Daas_stripe import Daas_stripe
from places.Ext_popup import Ext_popup
from places.Images_popup import Images_popup
from places.Images_wizard import Images_wizard
from places.Mobilefooter import Mobilefooter
from places.Portal_popup import Portal_popup
from places.Promofooter import Promofooter
from places.Promoliba import Promoliba
from places.Smart_banner import Smart_banner
from places.Softlink import Softlink
from places.Stripe import Stripe
from places.Teaser import Teaser
from places.Touch_banner import Touch_banner
from places.Touch_teaser import Touch_teaser
from places.Vb_popup import Vb_popup
from places.Vb_stripe import Vb_stripe
from places.Wizard import Wizard

template = {"products": "'#{},not_match,{}'"}
desktop_mobile_filter = "('#uat:isMobile,eq,{}'&{})"

product_filter_map = {
    "set": {
        'products': ['searchextchrome_chr',
                     'searchextcomm',
                     'homesearchextchrome_chr',
                     'startsearchextcomm'],
        'ys': ['searchextchrome', 'homesearchextchrome']
    },
    "home": {
        'products': ['startsearchextcomm',
                     'startextchrome_chr',
                     'homesearchextchrome_chr',
                     'homeextchrome_chr'],
        'ys': ['startextchrome', 'homeext', 'homesearchextchrome']
    },
    "sethome": {
        'products': ['startsearchextcomm',
                    'homesearchextchrome_chr'],

        'ys': ['startextchrome', 'homeext', 'searchextchrome']
    },
    'browser': {
        'products': ['desktop@@@yabrowser',
                     'mobile@@@com.yandex.browser',
                     'mobile@@@ru.yandex.mobilesearch'], 'yp': ['yb']
    },
    'search': {'products': ['ru.yandex.searchplugin']},
    'vb': {'products': ['vbch', 'vbchrome', 'vbff']},
    'searchline': {'products': ['winsearchbar']},
    'launcher': {'products':['com.yandex.launcher']}
}

base_filter = "&".join(["('#lr,eq,977'|'#lr,eq,225')", "'#lang,eq,ru'",
                        "'#ua,ic_match,%windows%'", "'#uat:isMobile,eq,false'","'#referer,match,%search%'"])
chrome_filter = "&".join([base_filter, "'#uat:BrowserName,eq,Chrome'"])
msie_filter = "&".join([base_filter, "('#uat:BrowserName,eq,MSIE'|'#uat:BrowserName,eq,Edge')"])
firefox_filter = "&".join([base_filter, "'#uat:BrowserName,eq,Firefox'"])
opera_filter = "&".join([base_filter, "'#uat:BrowserName,eq,Opera'"])

clone_config = [
    {
        'position': 'left-bottom',
        'install_text': u'Нажмите кнопку, на которую указывает стрелка',
        'filter': chrome_filter,
        'tag': "chrome"
    },
    # {
    #     'position': 'left-bottom',
    #     'install_text': u'Спасибо, что скачали Яндекс.Браузер <br> Чтобы установить его, нажмите кнопку, на которую указывает стрелка, <br> а затем запустите установщик и следуйте инструкциям',
    #     'filter': chrome_filter,
    #     'tag': "chrome2"
    # },
    {
        'position': 'center-bottom',
        'install_text': u'Нажмите кнопку «Выполнить» на панели внизу',
        'filter': msie_filter,
        'tag': 'msie'
    },
    # {
    #     'position': 'center-bottom',
    #     'install_text': u'Спасибо, что выбрали Яндекс.Браузер <br> Когда он скачается, нажмите кнопку «Выполнить» на панели внизу, <br> а затем — кнопку «Начать пользоваться»',
    #     'filter': msie_filter,
    #     'tag': "msie2"
    # },
    {
        'position': 'right-top-guide',
        'install_text': u'Нажмите на синюю стрелку и выберите верхний файл',
        'install_description': u'После этого начнётся установка Яндекс.Браузера',
        'guide_image': 'https://avatars.mds.yandex.net/get-serp/15230/8b832e8e-5ce2-435c-ab15-299973513b9c/orig',
        'filter': firefox_filter,
        'tag': "firefox"
    },
    {
        'position': 'right-top-guide',
        'install_text': u'Нажмите на стрелку и выберите верхний файл',
        'install_description': u'После этого начнётся установка Яндекс.Браузера',
        'guide_image': 'https://avatars.mds.yandex.net/get-serp/15207/4337a6df-f7a6-45fd-89fd-df8c142e7dbe/orig',
        'filter': opera_filter,
        'tag': "opera"
    },
]


def generate_filter(type_, lst):
    desktopmobile = []
    other = []
    for x in lst:
        if x.startswith('desktop@@@') or x.startswith('mobile@@@'):
            desktopmobile.append(
                desktop_mobile_filter.format(
                    'false' if x.startswith('desktop@@@') else 'true',
                    template.get(
                        type_, "'#{},not_match,%{}%'"
                    ).format(type_, x.split('@@@')[-1])
                )
            )
        else:
            other.append(template.get(
                type_, "'#{},not_match,%{}%'"
            ).format(type_, x))

    if desktopmobile:
        other.append('({})'.format('|'.join(desktopmobile)))
    return '&'.join(other)


def check_filter(candidate, import_=False):
    if ('__product' not in candidate or
        'filter' not in candidate or
            candidate['__product'] not in product_filter_map):
        if import_:
            return
        else:
            return candidate
    result = deepcopy(candidate)
    mapped = product_filter_map[candidate['__product']]
    for type_ in mapped:
        #if "#{},".format(type_) not in result['filter']:
        generated = generate_filter(type_, mapped[type_])
        if generated:
            result['filter'] += (
                ('&' if result['filter'] else '') + generated
            )
        else:
            print('couldn\'t generate filter for {} {}'
                  .format(candidate['__product'], type_))
    return result

def check_if_locked(lockpath):
    try:
        with codecs.open(lockpath, 'r', 'utf8') as f:
            contents = f.read().rstrip()
    except IOError:
        contents = 'free'
        with codecs.open(lockpath, 'w', 'utf8') as f:
            f.write('free')
    search_for_process = psaux()
    if 'locked' in contents and search_for_process:
        print "previous not finished yet"
        sys.exit(0)
    else:
        with codecs.open(lockpath, 'w', 'utf8') as f:
            f.write('locked at {}'.format(datetime.datetime.now()))


def psaux():
    ps = subprocess.Popen(
        ['ps', 'aux'], stdout=subprocess.PIPE).communicate()[0]
    processes = ps.split('\n')
    nfields = len(processes[0].split()) - 1
    p = 0
    for row in processes[1:]:
        if len(row.split(None, nfields)) > 0 and "banana-fetch" in row.split(None, nfields)[-1]:
            print row
            p += 1
    if p > 1:
        return True
    else:
        return False


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("-classname", help="class", type=str)
    parser.add_argument(
        "-placeid", help="placeId in banana", nargs='+', type=str)
    parser.add_argument("-collection", help="collection", type=str)
    parser.add_argument("-host", help="host", type=str)
    parser.add_argument("-prefix", help="bannerid prefix", type=str)
    parser.add_argument("-zerogroup_default", help="number of new", type=int)
    parser.add_argument('-excluded_orders', '--excludeorder',
                                            help="excluding orders", nargs='+', type=int)
    parser.add_argument('-included_orders', '--includeorder',
                                            help="including orders", nargs='+', type=int)
    parser.add_argument('-downloaddata', help="download data", type=str)
    parser.add_argument('-nofiltering', help="dont filter data", type=str)
    parser.add_argument('-upload', help="upload to switch", type=str)
    parser.add_argument('-verbose', help="print stat", type=str)
    parser.add_argument('-clone_browser', help="clone banners for browser", type=str)

    args = parser.parse_args()

    if args.classname != None:
        config = json.load(open("import_config.json"))
        params = config[args.classname]
        for param, paramvalue in args.__dict__.items():
            if paramvalue != None:
                params[param] = paramvalue
        config = {args.classname: params}
        params["do"] = True
        print args.classname
        print params
        globals()[args.classname](params)

    else:
        check_if_locked("locklog.txt")
        config = json.load(open("import_config.json"))
        for classname, params in config.items():
            print classname
            print params
            params["classname"] = classname
            try:
                globals()[classname](params)
            except Exception, e:
                with open("log.txt", "a") as log:
                    log.write("{}\tfailed {}\n".format(
                        time.strftime("%Y-%m-%d %H:%M:%S", time.gmtime()), classname))
        with codecs.open("locklog.txt", 'w', 'utf8') as f:
            f.write('Free')

if __name__ == '__main__':
    main()
